/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates the registered identity provider’s product related configuration settings such as the subnets to provision
 * VPC endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSettings implements SdkPojo, Serializable, ToCopyableBuilder<UpdateSettings.Builder, UpdateSettings> {
    private static final SdkField<List<String>> ADD_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSubnets")
            .getter(getter(UpdateSettings::addSubnets))
            .setter(setter(Builder::addSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSubnets")
            .getter(getter(UpdateSettings::removeSubnets))
            .setter(setter(Builder::removeSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupId").getter(getter(UpdateSettings::securityGroupId))
            .setter(setter(Builder::securityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_SUBNETS_FIELD,
            REMOVE_SUBNETS_FIELD, SECURITY_GROUP_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> addSubnets;

    private final List<String> removeSubnets;

    private final String securityGroupId;

    private UpdateSettings(BuilderImpl builder) {
        this.addSubnets = builder.addSubnets;
        this.removeSubnets = builder.removeSubnets;
        this.securityGroupId = builder.securityGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSubnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddSubnets() {
        return addSubnets != null && !(addSubnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of one or more subnets in which License Manager will create a VPC endpoint for products that require
     * connectivity to activation servers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSubnets} method.
     * </p>
     * 
     * @return The ID of one or more subnets in which License Manager will create a VPC endpoint for products that
     *         require connectivity to activation servers.
     */
    public final List<String> addSubnets() {
        return addSubnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSubnets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveSubnets() {
        return removeSubnets != null && !(removeSubnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of one or more subnets to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSubnets} method.
     * </p>
     * 
     * @return The ID of one or more subnets to remove.
     */
    public final List<String> removeSubnets() {
        return removeSubnets;
    }

    /**
     * <p>
     * A security group ID that allows inbound TCP port 1688 communication between resources in your VPC and the VPC
     * endpoints for activation servers.
     * </p>
     * 
     * @return A security group ID that allows inbound TCP port 1688 communication between resources in your VPC and the
     *         VPC endpoints for activation servers.
     */
    public final String securityGroupId() {
        return securityGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSubnets() ? addSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSubnets() ? removeSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSettings)) {
            return false;
        }
        UpdateSettings other = (UpdateSettings) obj;
        return hasAddSubnets() == other.hasAddSubnets() && Objects.equals(addSubnets(), other.addSubnets())
                && hasRemoveSubnets() == other.hasRemoveSubnets() && Objects.equals(removeSubnets(), other.removeSubnets())
                && Objects.equals(securityGroupId(), other.securityGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSettings").add("AddSubnets", hasAddSubnets() ? addSubnets() : null)
                .add("RemoveSubnets", hasRemoveSubnets() ? removeSubnets() : null).add("SecurityGroupId", securityGroupId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddSubnets":
            return Optional.ofNullable(clazz.cast(addSubnets()));
        case "RemoveSubnets":
            return Optional.ofNullable(clazz.cast(removeSubnets()));
        case "SecurityGroupId":
            return Optional.ofNullable(clazz.cast(securityGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSettings, T> g) {
        return obj -> g.apply((UpdateSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateSettings> {
        /**
         * <p>
         * The ID of one or more subnets in which License Manager will create a VPC endpoint for products that require
         * connectivity to activation servers.
         * </p>
         * 
         * @param addSubnets
         *        The ID of one or more subnets in which License Manager will create a VPC endpoint for products that
         *        require connectivity to activation servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnets(Collection<String> addSubnets);

        /**
         * <p>
         * The ID of one or more subnets in which License Manager will create a VPC endpoint for products that require
         * connectivity to activation servers.
         * </p>
         * 
         * @param addSubnets
         *        The ID of one or more subnets in which License Manager will create a VPC endpoint for products that
         *        require connectivity to activation servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnets(String... addSubnets);

        /**
         * <p>
         * The ID of one or more subnets to remove.
         * </p>
         * 
         * @param removeSubnets
         *        The ID of one or more subnets to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnets(Collection<String> removeSubnets);

        /**
         * <p>
         * The ID of one or more subnets to remove.
         * </p>
         * 
         * @param removeSubnets
         *        The ID of one or more subnets to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnets(String... removeSubnets);

        /**
         * <p>
         * A security group ID that allows inbound TCP port 1688 communication between resources in your VPC and the VPC
         * endpoints for activation servers.
         * </p>
         * 
         * @param securityGroupId
         *        A security group ID that allows inbound TCP port 1688 communication between resources in your VPC and
         *        the VPC endpoints for activation servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupId(String securityGroupId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> addSubnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSubnets = DefaultSdkAutoConstructList.getInstance();

        private String securityGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSettings model) {
            addSubnets(model.addSubnets);
            removeSubnets(model.removeSubnets);
            securityGroupId(model.securityGroupId);
        }

        public final Collection<String> getAddSubnets() {
            if (addSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return addSubnets;
        }

        public final void setAddSubnets(Collection<String> addSubnets) {
            this.addSubnets = SubnetsCopier.copy(addSubnets);
        }

        @Override
        public final Builder addSubnets(Collection<String> addSubnets) {
            this.addSubnets = SubnetsCopier.copy(addSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnets(String... addSubnets) {
            addSubnets(Arrays.asList(addSubnets));
            return this;
        }

        public final Collection<String> getRemoveSubnets() {
            if (removeSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSubnets;
        }

        public final void setRemoveSubnets(Collection<String> removeSubnets) {
            this.removeSubnets = SubnetsCopier.copy(removeSubnets);
        }

        @Override
        public final Builder removeSubnets(Collection<String> removeSubnets) {
            this.removeSubnets = SubnetsCopier.copy(removeSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnets(String... removeSubnets) {
            removeSubnets(Arrays.asList(removeSubnets));
            return this;
        }

        public final String getSecurityGroupId() {
            return securityGroupId;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        @Override
        public UpdateSettings build() {
            return new UpdateSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
