/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterIdentityProviderResponse extends LicenseManagerUserSubscriptionsResponse implements
        ToCopyableBuilder<RegisterIdentityProviderResponse.Builder, RegisterIdentityProviderResponse> {
    private static final SdkField<IdentityProviderSummary> IDENTITY_PROVIDER_SUMMARY_FIELD = SdkField
            .<IdentityProviderSummary> builder(MarshallingType.SDK_POJO).memberName("IdentityProviderSummary")
            .getter(getter(RegisterIdentityProviderResponse::identityProviderSummary))
            .setter(setter(Builder::identityProviderSummary)).constructor(IdentityProviderSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IDENTITY_PROVIDER_SUMMARY_FIELD));

    private final IdentityProviderSummary identityProviderSummary;

    private RegisterIdentityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderSummary = builder.identityProviderSummary;
    }

    /**
     * <p>
     * Metadata that describes the results of an identity provider operation.
     * </p>
     * 
     * @return Metadata that describes the results of an identity provider operation.
     */
    public final IdentityProviderSummary identityProviderSummary() {
        return identityProviderSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterIdentityProviderResponse)) {
            return false;
        }
        RegisterIdentityProviderResponse other = (RegisterIdentityProviderResponse) obj;
        return Objects.equals(identityProviderSummary(), other.identityProviderSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterIdentityProviderResponse").add("IdentityProviderSummary", identityProviderSummary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProviderSummary":
            return Optional.ofNullable(clazz.cast(identityProviderSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterIdentityProviderResponse, T> g) {
        return obj -> g.apply((RegisterIdentityProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerUserSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterIdentityProviderResponse> {
        /**
         * <p>
         * Metadata that describes the results of an identity provider operation.
         * </p>
         * 
         * @param identityProviderSummary
         *        Metadata that describes the results of an identity provider operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderSummary(IdentityProviderSummary identityProviderSummary);

        /**
         * <p>
         * Metadata that describes the results of an identity provider operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderSummary.Builder} avoiding
         * the need to create one manually via {@link IdentityProviderSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProviderSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #identityProviderSummary(IdentityProviderSummary)}.
         * 
         * @param identityProviderSummary
         *        a consumer that will call methods on {@link IdentityProviderSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderSummary(IdentityProviderSummary)
         */
        default Builder identityProviderSummary(Consumer<IdentityProviderSummary.Builder> identityProviderSummary) {
            return identityProviderSummary(IdentityProviderSummary.builder().applyMutation(identityProviderSummary).build());
        }
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsResponse.BuilderImpl implements Builder {
        private IdentityProviderSummary identityProviderSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterIdentityProviderResponse model) {
            super(model);
            identityProviderSummary(model.identityProviderSummary);
        }

        public final IdentityProviderSummary.Builder getIdentityProviderSummary() {
            return identityProviderSummary != null ? identityProviderSummary.toBuilder() : null;
        }

        public final void setIdentityProviderSummary(IdentityProviderSummary.BuilderImpl identityProviderSummary) {
            this.identityProviderSummary = identityProviderSummary != null ? identityProviderSummary.build() : null;
        }

        @Override
        public final Builder identityProviderSummary(IdentityProviderSummary identityProviderSummary) {
            this.identityProviderSummary = identityProviderSummary;
            return this;
        }

        @Override
        public RegisterIdentityProviderResponse build() {
            return new RegisterIdentityProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
