/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegisteredSubscriptionProvidersRequest extends LicenseManagerLinuxSubscriptionsRequest implements
        ToCopyableBuilder<ListRegisteredSubscriptionProvidersRequest.Builder, ListRegisteredSubscriptionProvidersRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRegisteredSubscriptionProvidersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRegisteredSubscriptionProvidersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> SUBSCRIPTION_PROVIDER_SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubscriptionProviderSources")
            .getter(getter(ListRegisteredSubscriptionProvidersRequest::subscriptionProviderSourcesAsStrings))
            .setter(setter(Builder::subscriptionProviderSourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderSources")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, SUBSCRIPTION_PROVIDER_SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> subscriptionProviderSources;

    private ListRegisteredSubscriptionProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.subscriptionProviderSources = builder.subscriptionProviderSources;
    }

    /**
     * <p>
     * The maximum items to return in a request.
     * </p>
     * 
     * @return The maximum items to return in a request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the nextToken from a previously truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the nextToken from a previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * To filter your results, specify which subscription providers to return in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptionProviderSources} method.
     * </p>
     * 
     * @return To filter your results, specify which subscription providers to return in the list.
     */
    public final List<SubscriptionProviderSource> subscriptionProviderSources() {
        return SubscriptionProviderSourceListCopier.copyStringToEnum(subscriptionProviderSources);
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscriptionProviderSources property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubscriptionProviderSources() {
        return subscriptionProviderSources != null && !(subscriptionProviderSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * To filter your results, specify which subscription providers to return in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptionProviderSources} method.
     * </p>
     * 
     * @return To filter your results, specify which subscription providers to return in the list.
     */
    public final List<String> subscriptionProviderSourcesAsStrings() {
        return subscriptionProviderSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSubscriptionProviderSources() ? subscriptionProviderSourcesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegisteredSubscriptionProvidersRequest)) {
            return false;
        }
        ListRegisteredSubscriptionProvidersRequest other = (ListRegisteredSubscriptionProvidersRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasSubscriptionProviderSources() == other.hasSubscriptionProviderSources()
                && Objects.equals(subscriptionProviderSourcesAsStrings(), other.subscriptionProviderSourcesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListRegisteredSubscriptionProvidersRequest")
                .add("MaxResults", maxResults())
                .add("NextToken", nextToken())
                .add("SubscriptionProviderSources",
                        hasSubscriptionProviderSources() ? subscriptionProviderSourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SubscriptionProviderSources":
            return Optional.ofNullable(clazz.cast(subscriptionProviderSourcesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SubscriptionProviderSources", SUBSCRIPTION_PROVIDER_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegisteredSubscriptionProvidersRequest, T> g) {
        return obj -> g.apply((ListRegisteredSubscriptionProvidersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LicenseManagerLinuxSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRegisteredSubscriptionProvidersRequest> {
        /**
         * <p>
         * The maximum items to return in a request.
         * </p>
         * 
         * @param maxResults
         *        The maximum items to return in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to specify where to start paginating. This is the nextToken from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the nextToken from a previously truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * To filter your results, specify which subscription providers to return in the list.
         * </p>
         * 
         * @param subscriptionProviderSources
         *        To filter your results, specify which subscription providers to return in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderSourcesWithStrings(Collection<String> subscriptionProviderSources);

        /**
         * <p>
         * To filter your results, specify which subscription providers to return in the list.
         * </p>
         * 
         * @param subscriptionProviderSources
         *        To filter your results, specify which subscription providers to return in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderSourcesWithStrings(String... subscriptionProviderSources);

        /**
         * <p>
         * To filter your results, specify which subscription providers to return in the list.
         * </p>
         * 
         * @param subscriptionProviderSources
         *        To filter your results, specify which subscription providers to return in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderSources(Collection<SubscriptionProviderSource> subscriptionProviderSources);

        /**
         * <p>
         * To filter your results, specify which subscription providers to return in the list.
         * </p>
         * 
         * @param subscriptionProviderSources
         *        To filter your results, specify which subscription providers to return in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderSources(SubscriptionProviderSource... subscriptionProviderSources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerLinuxSubscriptionsRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> subscriptionProviderSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegisteredSubscriptionProvidersRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            subscriptionProviderSourcesWithStrings(model.subscriptionProviderSources);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getSubscriptionProviderSources() {
            if (subscriptionProviderSources instanceof SdkAutoConstructList) {
                return null;
            }
            return subscriptionProviderSources;
        }

        public final void setSubscriptionProviderSources(Collection<String> subscriptionProviderSources) {
            this.subscriptionProviderSources = SubscriptionProviderSourceListCopier.copy(subscriptionProviderSources);
        }

        @Override
        public final Builder subscriptionProviderSourcesWithStrings(Collection<String> subscriptionProviderSources) {
            this.subscriptionProviderSources = SubscriptionProviderSourceListCopier.copy(subscriptionProviderSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionProviderSourcesWithStrings(String... subscriptionProviderSources) {
            subscriptionProviderSourcesWithStrings(Arrays.asList(subscriptionProviderSources));
            return this;
        }

        @Override
        public final Builder subscriptionProviderSources(Collection<SubscriptionProviderSource> subscriptionProviderSources) {
            this.subscriptionProviderSources = SubscriptionProviderSourceListCopier.copyEnumToString(subscriptionProviderSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionProviderSources(SubscriptionProviderSource... subscriptionProviderSources) {
            subscriptionProviderSources(Arrays.asList(subscriptionProviderSources));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRegisteredSubscriptionProvidersRequest build() {
            return new ListRegisteredSubscriptionProvidersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
