/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.DeregisterSubscriptionProviderRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.DeregisterSubscriptionProviderResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetRegisteredSubscriptionProviderRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetRegisteredSubscriptionProviderResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.InternalServerException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LicenseManagerLinuxSubscriptionsException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisterSubscriptionProviderRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisterSubscriptionProviderResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ResourceNotFoundException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.TagResourceRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.TagResourceResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ThrottlingException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UntagResourceRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UntagResourceResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ValidationException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListRegisteredSubscriptionProvidersIterable;

/**
 * Service client for accessing AWS License Manager Linux Subscriptions. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * With License Manager, you can discover and track your commercial Linux subscriptions on running Amazon EC2 instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LicenseManagerLinuxSubscriptionsClient extends AwsClient {
    String SERVICE_NAME = "license-manager-linux-subscriptions";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "license-manager-linux-subscriptions";

    /**
     * <p>
     * Remove a third-party subscription provider from the Bring Your Own License (BYOL) subscriptions registered to
     * your account.
     * </p>
     *
     * @param deregisterSubscriptionProviderRequest
     * @return Result of the DeregisterSubscriptionProvider operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.DeregisterSubscriptionProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/DeregisterSubscriptionProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterSubscriptionProviderResponse deregisterSubscriptionProvider(
            DeregisterSubscriptionProviderRequest deregisterSubscriptionProviderRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a third-party subscription provider from the Bring Your Own License (BYOL) subscriptions registered to
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterSubscriptionProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterSubscriptionProviderRequest#builder()}
     * </p>
     *
     * @param deregisterSubscriptionProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.DeregisterSubscriptionProviderRequest.Builder}
     *        to create a request.
     * @return Result of the DeregisterSubscriptionProvider operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.DeregisterSubscriptionProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/DeregisterSubscriptionProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterSubscriptionProviderResponse deregisterSubscriptionProvider(
            Consumer<DeregisterSubscriptionProviderRequest.Builder> deregisterSubscriptionProviderRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, LicenseManagerLinuxSubscriptionsException {
        return deregisterSubscriptionProvider(DeregisterSubscriptionProviderRequest.builder()
                .applyMutation(deregisterSubscriptionProviderRequest).build());
    }

    /**
     * <p>
     * Get details for a Bring Your Own License (BYOL) subscription that's registered to your account.
     * </p>
     *
     * @param getRegisteredSubscriptionProviderRequest
     * @return Result of the GetRegisteredSubscriptionProvider operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.GetRegisteredSubscriptionProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/GetRegisteredSubscriptionProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRegisteredSubscriptionProviderResponse getRegisteredSubscriptionProvider(
            GetRegisteredSubscriptionProviderRequest getRegisteredSubscriptionProviderRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details for a Bring Your Own License (BYOL) subscription that's registered to your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegisteredSubscriptionProviderRequest.Builder}
     * avoiding the need to create one manually via {@link GetRegisteredSubscriptionProviderRequest#builder()}
     * </p>
     *
     * @param getRegisteredSubscriptionProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetRegisteredSubscriptionProviderRequest.Builder}
     *        to create a request.
     * @return Result of the GetRegisteredSubscriptionProvider operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.GetRegisteredSubscriptionProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/GetRegisteredSubscriptionProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRegisteredSubscriptionProviderResponse getRegisteredSubscriptionProvider(
            Consumer<GetRegisteredSubscriptionProviderRequest.Builder> getRegisteredSubscriptionProviderRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, LicenseManagerLinuxSubscriptionsException {
        return getRegisteredSubscriptionProvider(GetRegisteredSubscriptionProviderRequest.builder()
                .applyMutation(getRegisteredSubscriptionProviderRequest).build());
    }

    /**
     * <p>
     * Lists the Linux subscriptions service settings for your account.
     * </p>
     *
     * @param getServiceSettingsRequest
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.GetServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Linux subscriptions service settings for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSettingsRequest#builder()}
     * </p>
     *
     * @param getServiceSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetServiceSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.GetServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(Consumer<GetServiceSettingsRequest.Builder> getServiceSettingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return getServiceSettings(GetServiceSettingsRequest.builder().applyMutation(getServiceSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions.
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return Result of the ListLinuxSubscriptionInstances operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesResponse listLinuxSubscriptionInstances(
            ListLinuxSubscriptionInstancesRequest listLinuxSubscriptionInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinuxSubscriptionInstancesRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest.Builder}
     *        to create a request. NextToken length limit is half of ddb accepted limit. Increase this limit if
     *        parameters in request increases.
     * @return Result of the ListLinuxSubscriptionInstances operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesResponse listLinuxSubscriptionInstances(
            Consumer<ListLinuxSubscriptionInstancesRequest.Builder> listLinuxSubscriptionInstancesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptionInstances(ListLinuxSubscriptionInstancesRequest.builder()
                .applyMutation(listLinuxSubscriptionInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client
     *             .listLinuxSubscriptionInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesIterable listLinuxSubscriptionInstancesPaginator(
            ListLinuxSubscriptionInstancesRequest listLinuxSubscriptionInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return new ListLinuxSubscriptionInstancesIterable(this, listLinuxSubscriptionInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client
     *             .listLinuxSubscriptionInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinuxSubscriptionInstancesRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest.Builder}
     *        to create a request. NextToken length limit is half of ddb accepted limit. Increase this limit if
     *        parameters in request increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesIterable listLinuxSubscriptionInstancesPaginator(
            Consumer<ListLinuxSubscriptionInstancesRequest.Builder> listLinuxSubscriptionInstancesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptionInstancesPaginator(ListLinuxSubscriptionInstancesRequest.builder()
                .applyMutation(listLinuxSubscriptionInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the Linux subscriptions that have been discovered. If you have linked your organization, the returned
     * results will include data aggregated across your accounts in Organizations.
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return Result of the ListLinuxSubscriptions operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsResponse listLinuxSubscriptions(ListLinuxSubscriptionsRequest listLinuxSubscriptionsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Linux subscriptions that have been discovered. If you have linked your organization, the returned
     * results will include data aggregated across your accounts in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLinuxSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest.Builder}
     *        to create a request. NextToken length limit is half of ddb accepted limit. Increase this limit if
     *        parameters in request increases.
     * @return Result of the ListLinuxSubscriptions operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsResponse listLinuxSubscriptions(
            Consumer<ListLinuxSubscriptionsRequest.Builder> listLinuxSubscriptionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptions(ListLinuxSubscriptionsRequest.builder().applyMutation(listLinuxSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client
     *             .listLinuxSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsIterable listLinuxSubscriptionsPaginator(
            ListLinuxSubscriptionsRequest listLinuxSubscriptionsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, LicenseManagerLinuxSubscriptionsException {
        return new ListLinuxSubscriptionsIterable(this, listLinuxSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client
     *             .listLinuxSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLinuxSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest.Builder}
     *        to create a request. NextToken length limit is half of ddb accepted limit. Increase this limit if
     *        parameters in request increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsIterable listLinuxSubscriptionsPaginator(
            Consumer<ListLinuxSubscriptionsRequest.Builder> listLinuxSubscriptionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptionsPaginator(ListLinuxSubscriptionsRequest.builder()
                .applyMutation(listLinuxSubscriptionsRequest).build());
    }

    /**
     * <p>
     * List Bring Your Own License (BYOL) subscription registration resources for your account.
     * </p>
     *
     * @param listRegisteredSubscriptionProvidersRequest
     * @return Result of the ListRegisteredSubscriptionProviders operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListRegisteredSubscriptionProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListRegisteredSubscriptionProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegisteredSubscriptionProvidersResponse listRegisteredSubscriptionProviders(
            ListRegisteredSubscriptionProvidersRequest listRegisteredSubscriptionProvidersRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Bring Your Own License (BYOL) subscription registration resources for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegisteredSubscriptionProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListRegisteredSubscriptionProvidersRequest#builder()}
     * </p>
     *
     * @param listRegisteredSubscriptionProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest.Builder}
     *        to create a request.
     * @return Result of the ListRegisteredSubscriptionProviders operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListRegisteredSubscriptionProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListRegisteredSubscriptionProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegisteredSubscriptionProvidersResponse listRegisteredSubscriptionProviders(
            Consumer<ListRegisteredSubscriptionProvidersRequest.Builder> listRegisteredSubscriptionProvidersRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listRegisteredSubscriptionProviders(ListRegisteredSubscriptionProvidersRequest.builder()
                .applyMutation(listRegisteredSubscriptionProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegisteredSubscriptionProviders(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListRegisteredSubscriptionProvidersIterable responses = client.listRegisteredSubscriptionProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListRegisteredSubscriptionProvidersIterable responses = client
     *             .listRegisteredSubscriptionProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListRegisteredSubscriptionProvidersIterable responses = client.listRegisteredSubscriptionProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegisteredSubscriptionProviders(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRegisteredSubscriptionProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListRegisteredSubscriptionProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListRegisteredSubscriptionProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegisteredSubscriptionProvidersIterable listRegisteredSubscriptionProvidersPaginator(
            ListRegisteredSubscriptionProvidersRequest listRegisteredSubscriptionProvidersRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return new ListRegisteredSubscriptionProvidersIterable(this, listRegisteredSubscriptionProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegisteredSubscriptionProviders(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListRegisteredSubscriptionProvidersIterable responses = client.listRegisteredSubscriptionProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListRegisteredSubscriptionProvidersIterable responses = client
     *             .listRegisteredSubscriptionProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListRegisteredSubscriptionProvidersIterable responses = client.listRegisteredSubscriptionProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegisteredSubscriptionProviders(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegisteredSubscriptionProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListRegisteredSubscriptionProvidersRequest#builder()}
     * </p>
     *
     * @param listRegisteredSubscriptionProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListRegisteredSubscriptionProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListRegisteredSubscriptionProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegisteredSubscriptionProvidersIterable listRegisteredSubscriptionProvidersPaginator(
            Consumer<ListRegisteredSubscriptionProvidersRequest.Builder> listRegisteredSubscriptionProvidersRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listRegisteredSubscriptionProvidersPaginator(ListRegisteredSubscriptionProvidersRequest.builder()
                .applyMutation(listRegisteredSubscriptionProvidersRequest).build());
    }

    /**
     * <p>
     * List the metadata tags that are assigned to the specified Amazon Web Services resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the metadata tags that are assigned to the specified Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListTagsForResourceRequest.Builder}
     *        to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Register the supported third-party subscription provider for your Bring Your Own License (BYOL) subscription.
     * </p>
     *
     * @param registerSubscriptionProviderRequest
     * @return Result of the RegisterSubscriptionProvider operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.RegisterSubscriptionProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/RegisterSubscriptionProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterSubscriptionProviderResponse registerSubscriptionProvider(
            RegisterSubscriptionProviderRequest registerSubscriptionProviderRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Register the supported third-party subscription provider for your Bring Your Own License (BYOL) subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterSubscriptionProviderRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterSubscriptionProviderRequest#builder()}
     * </p>
     *
     * @param registerSubscriptionProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisterSubscriptionProviderRequest.Builder}
     *        to create a request.
     * @return Result of the RegisterSubscriptionProvider operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.RegisterSubscriptionProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/RegisterSubscriptionProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterSubscriptionProviderResponse registerSubscriptionProvider(
            Consumer<RegisterSubscriptionProviderRequest.Builder> registerSubscriptionProviderRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return registerSubscriptionProvider(RegisterSubscriptionProviderRequest.builder()
                .applyMutation(registerSubscriptionProviderRequest).build());
    }

    /**
     * <p>
     * Add metadata tags to the specified Amazon Web Services resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add metadata tags to the specified Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.TagResourceRequest.Builder}
     *        to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, LicenseManagerLinuxSubscriptionsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove one or more metadata tag from the specified Amazon Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.UntagResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more metadata tag from the specified Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UntagResourceRequest.Builder}
     *        to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         Unable to find the requested Amazon Web Services resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.UntagResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the service settings for Linux subscriptions.
     * </p>
     *
     * @param updateServiceSettingsRequest
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.UpdateServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(UpdateServiceSettingsRequest updateServiceSettingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the service settings for Linux subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceSettingsRequest#builder()}
     * </p>
     *
     * @param updateServiceSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.UpdateServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(
            Consumer<UpdateServiceSettingsRequest.Builder> updateServiceSettingsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return updateServiceSettings(UpdateServiceSettingsRequest.builder().applyMutation(updateServiceSettingsRequest).build());
    }

    /**
     * Create a {@link LicenseManagerLinuxSubscriptionsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LicenseManagerLinuxSubscriptionsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LicenseManagerLinuxSubscriptionsClient}.
     */
    static LicenseManagerLinuxSubscriptionsClientBuilder builder() {
        return new DefaultLicenseManagerLinuxSubscriptionsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default LicenseManagerLinuxSubscriptionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
