/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LicenseManagerLinuxSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Status;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.StringListCopier;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceSettingsResponse
extends LicenseManagerLinuxSubscriptionsResponse
implements ToCopyableBuilder<Builder, UpdateServiceSettingsResponse> {
    private static final SdkField<List<String>> HOME_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HomeRegions").getter(UpdateServiceSettingsResponse.getter(UpdateServiceSettingsResponse::homeRegions)).setter(UpdateServiceSettingsResponse.setter(Builder::homeRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinuxSubscriptionsDiscovery").getter(UpdateServiceSettingsResponse.getter(UpdateServiceSettingsResponse::linuxSubscriptionsDiscoveryAsString)).setter(UpdateServiceSettingsResponse.setter(Builder::linuxSubscriptionsDiscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinuxSubscriptionsDiscovery").build()}).build();
    private static final SdkField<LinuxSubscriptionsDiscoverySettings> LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinuxSubscriptionsDiscoverySettings").getter(UpdateServiceSettingsResponse.getter(UpdateServiceSettingsResponse::linuxSubscriptionsDiscoverySettings)).setter(UpdateServiceSettingsResponse.setter(Builder::linuxSubscriptionsDiscoverySettings)).constructor(LinuxSubscriptionsDiscoverySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinuxSubscriptionsDiscoverySettings").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateServiceSettingsResponse.getter(UpdateServiceSettingsResponse::statusAsString)).setter(UpdateServiceSettingsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StatusMessage").getter(UpdateServiceSettingsResponse.getter(UpdateServiceSettingsResponse::statusMessage)).setter(UpdateServiceSettingsResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_REGIONS_FIELD, LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD, LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceSettingsResponse.memberNameToFieldInitializer();
    private final List<String> homeRegions;
    private final String linuxSubscriptionsDiscovery;
    private final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;
    private final String status;
    private final Map<String, String> statusMessage;

    private UpdateServiceSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.homeRegions = builder.homeRegions;
        this.linuxSubscriptionsDiscovery = builder.linuxSubscriptionsDiscovery;
        this.linuxSubscriptionsDiscoverySettings = builder.linuxSubscriptionsDiscoverySettings;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final boolean hasHomeRegions() {
        return this.homeRegions != null && !(this.homeRegions instanceof SdkAutoConstructList);
    }

    public final List<String> homeRegions() {
        return this.homeRegions;
    }

    public final LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery() {
        return LinuxSubscriptionsDiscovery.fromValue(this.linuxSubscriptionsDiscovery);
    }

    public final String linuxSubscriptionsDiscoveryAsString() {
        return this.linuxSubscriptionsDiscovery;
    }

    public final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings() {
        return this.linuxSubscriptionsDiscoverySettings;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasStatusMessage() {
        return this.statusMessage != null && !(this.statusMessage instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHomeRegions() ? this.homeRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxSubscriptionsDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxSubscriptionsDiscoverySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusMessage() ? this.statusMessage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSettingsResponse)) {
            return false;
        }
        UpdateServiceSettingsResponse other = (UpdateServiceSettingsResponse)((Object)obj);
        return this.hasHomeRegions() == other.hasHomeRegions() && Objects.equals(this.homeRegions(), other.homeRegions()) && Objects.equals(this.linuxSubscriptionsDiscoveryAsString(), other.linuxSubscriptionsDiscoveryAsString()) && Objects.equals(this.linuxSubscriptionsDiscoverySettings(), other.linuxSubscriptionsDiscoverySettings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusMessage() == other.hasStatusMessage() && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceSettingsResponse").add("HomeRegions", this.hasHomeRegions() ? this.homeRegions() : null).add("LinuxSubscriptionsDiscovery", (Object)this.linuxSubscriptionsDiscoveryAsString()).add("LinuxSubscriptionsDiscoverySettings", (Object)this.linuxSubscriptionsDiscoverySettings()).add("Status", (Object)this.statusAsString()).add("StatusMessage", this.hasStatusMessage() ? this.statusMessage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HomeRegions": {
                return Optional.ofNullable(clazz.cast(this.homeRegions()));
            }
            case "LinuxSubscriptionsDiscovery": {
                return Optional.ofNullable(clazz.cast(this.linuxSubscriptionsDiscoveryAsString()));
            }
            case "LinuxSubscriptionsDiscoverySettings": {
                return Optional.ofNullable(clazz.cast(this.linuxSubscriptionsDiscoverySettings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HomeRegions", HOME_REGIONS_FIELD);
        map.put("LinuxSubscriptionsDiscovery", LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD);
        map.put("LinuxSubscriptionsDiscoverySettings", LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSettingsResponse, T> g) {
        return obj -> g.apply((UpdateServiceSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerLinuxSubscriptionsResponse.BuilderImpl
    implements Builder {
        private List<String> homeRegions = DefaultSdkAutoConstructList.getInstance();
        private String linuxSubscriptionsDiscovery;
        private LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;
        private String status;
        private Map<String, String> statusMessage = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSettingsResponse model) {
            super(model);
            this.homeRegions(model.homeRegions);
            this.linuxSubscriptionsDiscovery(model.linuxSubscriptionsDiscovery);
            this.linuxSubscriptionsDiscoverySettings(model.linuxSubscriptionsDiscoverySettings);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Collection<String> getHomeRegions() {
            if (this.homeRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.homeRegions;
        }

        public final void setHomeRegions(Collection<String> homeRegions) {
            this.homeRegions = StringListCopier.copy(homeRegions);
        }

        @Override
        public final Builder homeRegions(Collection<String> homeRegions) {
            this.homeRegions = StringListCopier.copy(homeRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeRegions(String ... homeRegions) {
            this.homeRegions(Arrays.asList(homeRegions));
            return this;
        }

        public final String getLinuxSubscriptionsDiscovery() {
            return this.linuxSubscriptionsDiscovery;
        }

        public final void setLinuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
            return this;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery(linuxSubscriptionsDiscovery == null ? null : linuxSubscriptionsDiscovery.toString());
            return this;
        }

        public final LinuxSubscriptionsDiscoverySettings.Builder getLinuxSubscriptionsDiscoverySettings() {
            return this.linuxSubscriptionsDiscoverySettings != null ? this.linuxSubscriptionsDiscoverySettings.toBuilder() : null;
        }

        public final void setLinuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings.BuilderImpl linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings != null ? linuxSubscriptionsDiscoverySettings.build() : null;
        }

        @Override
        public final Builder linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getStatusMessage() {
            if (this.statusMessage instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statusMessage;
        }

        public final void setStatusMessage(Map<String, String> statusMessage) {
            this.statusMessage = StringMapCopier.copy(statusMessage);
        }

        @Override
        public final Builder statusMessage(Map<String, String> statusMessage) {
            this.statusMessage = StringMapCopier.copy(statusMessage);
            return this;
        }

        @Override
        public UpdateServiceSettingsResponse build() {
            return new UpdateServiceSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerLinuxSubscriptionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceSettingsResponse> {
        public Builder homeRegions(Collection<String> var1);

        public Builder homeRegions(String ... var1);

        public Builder linuxSubscriptionsDiscovery(String var1);

        public Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery var1);

        public Builder linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings var1);

        default public Builder linuxSubscriptionsDiscoverySettings(Consumer<LinuxSubscriptionsDiscoverySettings.Builder> linuxSubscriptionsDiscoverySettings) {
            return this.linuxSubscriptionsDiscoverySettings((LinuxSubscriptionsDiscoverySettings)((LinuxSubscriptionsDiscoverySettings.Builder)LinuxSubscriptionsDiscoverySettings.builder().applyMutation(linuxSubscriptionsDiscoverySettings)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusMessage(Map<String, String> var1);
    }
}

