/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Instance;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse;

public class ListLinuxSubscriptionInstancesIterable
implements SdkIterable<ListLinuxSubscriptionInstancesResponse> {
    private final LicenseManagerLinuxSubscriptionsClient client;
    private final ListLinuxSubscriptionInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLinuxSubscriptionInstancesIterable(LicenseManagerLinuxSubscriptionsClient client, ListLinuxSubscriptionInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLinuxSubscriptionInstancesResponseFetcher();
    }

    public Iterator<ListLinuxSubscriptionInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Instance> instances() {
        Function<ListLinuxSubscriptionInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLinuxSubscriptionInstancesResponseFetcher
    implements SyncPageFetcher<ListLinuxSubscriptionInstancesResponse> {
        private ListLinuxSubscriptionInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListLinuxSubscriptionInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLinuxSubscriptionInstancesResponse nextPage(ListLinuxSubscriptionInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListLinuxSubscriptionInstancesIterable.this.client.listLinuxSubscriptionInstances(ListLinuxSubscriptionInstancesIterable.this.firstRequest);
            }
            return ListLinuxSubscriptionInstancesIterable.this.client.listLinuxSubscriptionInstances((ListLinuxSubscriptionInstancesRequest)((Object)ListLinuxSubscriptionInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

