/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountID").getter(Instance.getter(Instance::accountID)).setter(Instance.setter(Builder::accountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountID").build()}).build();
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiId").getter(Instance.getter(Instance::amiId)).setter(Instance.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()}).build();
    private static final SdkField<String> DUAL_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DualSubscription").getter(Instance.getter(Instance::dualSubscription)).setter(Instance.setter(Builder::dualSubscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DualSubscription").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceID").getter(Instance.getter(Instance::instanceID)).setter(Instance.setter(Builder::instanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceID").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(Instance.getter(Instance::instanceType)).setter(Instance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedTime").getter(Instance.getter(Instance::lastUpdatedTime)).setter(Instance.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OsVersion").getter(Instance.getter(Instance::osVersion)).setter(Instance.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()}).build();
    private static final SdkField<List<String>> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCode").getter(Instance.getter(Instance::productCode)).setter(Instance.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Instance.getter(Instance::region)).setter(Instance.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> REGISTERED_WITH_SUBSCRIPTION_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegisteredWithSubscriptionProvider").getter(Instance.getter(Instance::registeredWithSubscriptionProvider)).setter(Instance.setter(Builder::registeredWithSubscriptionProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredWithSubscriptionProvider").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Instance.getter(Instance::status)).setter(Instance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionName").getter(Instance.getter(Instance::subscriptionName)).setter(Instance.setter(Builder::subscriptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_PROVIDER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionProviderCreateTime").getter(Instance.getter(Instance::subscriptionProviderCreateTime)).setter(Instance.setter(Builder::subscriptionProviderCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderCreateTime").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_PROVIDER_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionProviderUpdateTime").getter(Instance.getter(Instance::subscriptionProviderUpdateTime)).setter(Instance.setter(Builder::subscriptionProviderUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderUpdateTime").build()}).build();
    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageOperation").getter(Instance.getter(Instance::usageOperation)).setter(Instance.setter(Builder::usageOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, AMI_ID_FIELD, DUAL_SUBSCRIPTION_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, LAST_UPDATED_TIME_FIELD, OS_VERSION_FIELD, PRODUCT_CODE_FIELD, REGION_FIELD, REGISTERED_WITH_SUBSCRIPTION_PROVIDER_FIELD, STATUS_FIELD, SUBSCRIPTION_NAME_FIELD, SUBSCRIPTION_PROVIDER_CREATE_TIME_FIELD, SUBSCRIPTION_PROVIDER_UPDATE_TIME_FIELD, USAGE_OPERATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountID;
    private final String amiId;
    private final String dualSubscription;
    private final String instanceID;
    private final String instanceType;
    private final String lastUpdatedTime;
    private final String osVersion;
    private final List<String> productCode;
    private final String region;
    private final String registeredWithSubscriptionProvider;
    private final String status;
    private final String subscriptionName;
    private final String subscriptionProviderCreateTime;
    private final String subscriptionProviderUpdateTime;
    private final String usageOperation;

    private Instance(BuilderImpl builder) {
        this.accountID = builder.accountID;
        this.amiId = builder.amiId;
        this.dualSubscription = builder.dualSubscription;
        this.instanceID = builder.instanceID;
        this.instanceType = builder.instanceType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.osVersion = builder.osVersion;
        this.productCode = builder.productCode;
        this.region = builder.region;
        this.registeredWithSubscriptionProvider = builder.registeredWithSubscriptionProvider;
        this.status = builder.status;
        this.subscriptionName = builder.subscriptionName;
        this.subscriptionProviderCreateTime = builder.subscriptionProviderCreateTime;
        this.subscriptionProviderUpdateTime = builder.subscriptionProviderUpdateTime;
        this.usageOperation = builder.usageOperation;
    }

    public final String accountID() {
        return this.accountID;
    }

    public final String amiId() {
        return this.amiId;
    }

    public final String dualSubscription() {
        return this.dualSubscription;
    }

    public final String instanceID() {
        return this.instanceID;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public final boolean hasProductCode() {
        return this.productCode != null && !(this.productCode instanceof SdkAutoConstructList);
    }

    public final List<String> productCode() {
        return this.productCode;
    }

    public final String region() {
        return this.region;
    }

    public final String registeredWithSubscriptionProvider() {
        return this.registeredWithSubscriptionProvider;
    }

    public final String status() {
        return this.status;
    }

    public final String subscriptionName() {
        return this.subscriptionName;
    }

    public final String subscriptionProviderCreateTime() {
        return this.subscriptionProviderCreateTime;
    }

    public final String subscriptionProviderUpdateTime() {
        return this.subscriptionProviderUpdateTime;
    }

    public final String usageOperation() {
        return this.usageOperation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dualSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCode() ? this.productCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredWithSubscriptionProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionProviderCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionProviderUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOperation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.accountID(), other.accountID()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.dualSubscription(), other.dualSubscription()) && Objects.equals(this.instanceID(), other.instanceID()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.osVersion(), other.osVersion()) && this.hasProductCode() == other.hasProductCode() && Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.registeredWithSubscriptionProvider(), other.registeredWithSubscriptionProvider()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.subscriptionName(), other.subscriptionName()) && Objects.equals(this.subscriptionProviderCreateTime(), other.subscriptionProviderCreateTime()) && Objects.equals(this.subscriptionProviderUpdateTime(), other.subscriptionProviderUpdateTime()) && Objects.equals(this.usageOperation(), other.usageOperation());
    }

    public final String toString() {
        return ToString.builder((String)"Instance").add("AccountID", (Object)this.accountID()).add("AmiId", (Object)this.amiId()).add("DualSubscription", (Object)this.dualSubscription()).add("InstanceID", (Object)this.instanceID()).add("InstanceType", (Object)this.instanceType()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("OsVersion", (Object)this.osVersion()).add("ProductCode", this.hasProductCode() ? this.productCode() : null).add("Region", (Object)this.region()).add("RegisteredWithSubscriptionProvider", (Object)this.registeredWithSubscriptionProvider()).add("Status", (Object)this.status()).add("SubscriptionName", (Object)this.subscriptionName()).add("SubscriptionProviderCreateTime", (Object)this.subscriptionProviderCreateTime()).add("SubscriptionProviderUpdateTime", (Object)this.subscriptionProviderUpdateTime()).add("UsageOperation", (Object)this.usageOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountID": {
                return Optional.ofNullable(clazz.cast(this.accountID()));
            }
            case "AmiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "DualSubscription": {
                return Optional.ofNullable(clazz.cast(this.dualSubscription()));
            }
            case "InstanceID": {
                return Optional.ofNullable(clazz.cast(this.instanceID()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "OsVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "RegisteredWithSubscriptionProvider": {
                return Optional.ofNullable(clazz.cast(this.registeredWithSubscriptionProvider()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SubscriptionName": {
                return Optional.ofNullable(clazz.cast(this.subscriptionName()));
            }
            case "SubscriptionProviderCreateTime": {
                return Optional.ofNullable(clazz.cast(this.subscriptionProviderCreateTime()));
            }
            case "SubscriptionProviderUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.subscriptionProviderUpdateTime()));
            }
            case "UsageOperation": {
                return Optional.ofNullable(clazz.cast(this.usageOperation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountID;
        private String amiId;
        private String dualSubscription;
        private String instanceID;
        private String instanceType;
        private String lastUpdatedTime;
        private String osVersion;
        private List<String> productCode = DefaultSdkAutoConstructList.getInstance();
        private String region;
        private String registeredWithSubscriptionProvider;
        private String status;
        private String subscriptionName;
        private String subscriptionProviderCreateTime;
        private String subscriptionProviderUpdateTime;
        private String usageOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.accountID(model.accountID);
            this.amiId(model.amiId);
            this.dualSubscription(model.dualSubscription);
            this.instanceID(model.instanceID);
            this.instanceType(model.instanceType);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.osVersion(model.osVersion);
            this.productCode(model.productCode);
            this.region(model.region);
            this.registeredWithSubscriptionProvider(model.registeredWithSubscriptionProvider);
            this.status(model.status);
            this.subscriptionName(model.subscriptionName);
            this.subscriptionProviderCreateTime(model.subscriptionProviderCreateTime);
            this.subscriptionProviderUpdateTime(model.subscriptionProviderUpdateTime);
            this.usageOperation(model.usageOperation);
        }

        public final String getAccountID() {
            return this.accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final String getDualSubscription() {
            return this.dualSubscription;
        }

        public final void setDualSubscription(String dualSubscription) {
            this.dualSubscription = dualSubscription;
        }

        @Override
        public final Builder dualSubscription(String dualSubscription) {
            this.dualSubscription = dualSubscription;
            return this;
        }

        public final String getInstanceID() {
            return this.instanceID;
        }

        public final void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        @Override
        public final Builder instanceID(String instanceID) {
            this.instanceID = instanceID;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final Collection<String> getProductCode() {
            if (this.productCode instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productCode;
        }

        public final void setProductCode(Collection<String> productCode) {
            this.productCode = ProductCodeListCopier.copy(productCode);
        }

        @Override
        public final Builder productCode(Collection<String> productCode) {
            this.productCode = ProductCodeListCopier.copy(productCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCode(String ... productCode) {
            this.productCode(Arrays.asList(productCode));
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getRegisteredWithSubscriptionProvider() {
            return this.registeredWithSubscriptionProvider;
        }

        public final void setRegisteredWithSubscriptionProvider(String registeredWithSubscriptionProvider) {
            this.registeredWithSubscriptionProvider = registeredWithSubscriptionProvider;
        }

        @Override
        public final Builder registeredWithSubscriptionProvider(String registeredWithSubscriptionProvider) {
            this.registeredWithSubscriptionProvider = registeredWithSubscriptionProvider;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final String getSubscriptionProviderCreateTime() {
            return this.subscriptionProviderCreateTime;
        }

        public final void setSubscriptionProviderCreateTime(String subscriptionProviderCreateTime) {
            this.subscriptionProviderCreateTime = subscriptionProviderCreateTime;
        }

        @Override
        public final Builder subscriptionProviderCreateTime(String subscriptionProviderCreateTime) {
            this.subscriptionProviderCreateTime = subscriptionProviderCreateTime;
            return this;
        }

        public final String getSubscriptionProviderUpdateTime() {
            return this.subscriptionProviderUpdateTime;
        }

        public final void setSubscriptionProviderUpdateTime(String subscriptionProviderUpdateTime) {
            this.subscriptionProviderUpdateTime = subscriptionProviderUpdateTime;
        }

        @Override
        public final Builder subscriptionProviderUpdateTime(String subscriptionProviderUpdateTime) {
            this.subscriptionProviderUpdateTime = subscriptionProviderUpdateTime;
            return this;
        }

        public final String getUsageOperation() {
            return this.usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder accountID(String var1);

        public Builder amiId(String var1);

        public Builder dualSubscription(String var1);

        public Builder instanceID(String var1);

        public Builder instanceType(String var1);

        public Builder lastUpdatedTime(String var1);

        public Builder osVersion(String var1);

        public Builder productCode(Collection<String> var1);

        public Builder productCode(String ... var1);

        public Builder region(String var1);

        public Builder registeredWithSubscriptionProvider(String var1);

        public Builder status(String var1);

        public Builder subscriptionName(String var1);

        public Builder subscriptionProviderCreateTime(String var1);

        public Builder subscriptionProviderUpdateTime(String var1);

        public Builder usageOperation(String var1);
    }
}

