/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LicenseManagerLinuxSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.SubscriptionProviderSource;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterSubscriptionProviderRequest
extends LicenseManagerLinuxSubscriptionsRequest
implements ToCopyableBuilder<Builder, RegisterSubscriptionProviderRequest> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(RegisterSubscriptionProviderRequest.getter(RegisterSubscriptionProviderRequest::secretArn)).setter(RegisterSubscriptionProviderRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_PROVIDER_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionProviderSource").getter(RegisterSubscriptionProviderRequest.getter(RegisterSubscriptionProviderRequest::subscriptionProviderSourceAsString)).setter(RegisterSubscriptionProviderRequest.setter(Builder::subscriptionProviderSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderSource").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RegisterSubscriptionProviderRequest.getter(RegisterSubscriptionProviderRequest::tags)).setter(RegisterSubscriptionProviderRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD, SUBSCRIPTION_PROVIDER_SOURCE_FIELD, TAGS_FIELD));
    private final String secretArn;
    private final String subscriptionProviderSource;
    private final Map<String, String> tags;

    private RegisterSubscriptionProviderRequest(BuilderImpl builder) {
        super(builder);
        this.secretArn = builder.secretArn;
        this.subscriptionProviderSource = builder.subscriptionProviderSource;
        this.tags = builder.tags;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final SubscriptionProviderSource subscriptionProviderSource() {
        return SubscriptionProviderSource.fromValue(this.subscriptionProviderSource);
    }

    public final String subscriptionProviderSourceAsString() {
        return this.subscriptionProviderSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionProviderSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterSubscriptionProviderRequest)) {
            return false;
        }
        RegisterSubscriptionProviderRequest other = (RegisterSubscriptionProviderRequest)((Object)obj);
        return Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.subscriptionProviderSourceAsString(), other.subscriptionProviderSourceAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterSubscriptionProviderRequest").add("SecretArn", (Object)this.secretArn()).add("SubscriptionProviderSource", (Object)this.subscriptionProviderSourceAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "SubscriptionProviderSource": {
                return Optional.ofNullable(clazz.cast(this.subscriptionProviderSourceAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterSubscriptionProviderRequest, T> g) {
        return obj -> g.apply((RegisterSubscriptionProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerLinuxSubscriptionsRequest.BuilderImpl
    implements Builder {
        private String secretArn;
        private String subscriptionProviderSource;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterSubscriptionProviderRequest model) {
            super(model);
            this.secretArn(model.secretArn);
            this.subscriptionProviderSource(model.subscriptionProviderSource);
            this.tags(model.tags);
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSubscriptionProviderSource() {
            return this.subscriptionProviderSource;
        }

        public final void setSubscriptionProviderSource(String subscriptionProviderSource) {
            this.subscriptionProviderSource = subscriptionProviderSource;
        }

        @Override
        public final Builder subscriptionProviderSource(String subscriptionProviderSource) {
            this.subscriptionProviderSource = subscriptionProviderSource;
            return this;
        }

        @Override
        public final Builder subscriptionProviderSource(SubscriptionProviderSource subscriptionProviderSource) {
            this.subscriptionProviderSource(subscriptionProviderSource == null ? null : subscriptionProviderSource.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterSubscriptionProviderRequest build() {
            return new RegisterSubscriptionProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerLinuxSubscriptionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterSubscriptionProviderRequest> {
        public Builder secretArn(String var1);

        public Builder subscriptionProviderSource(String var1);

        public Builder subscriptionProviderSource(SubscriptionProviderSource var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

