/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Instance;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse;

public class ListLinuxSubscriptionInstancesPublisher
implements SdkPublisher<ListLinuxSubscriptionInstancesResponse> {
    private final LicenseManagerLinuxSubscriptionsAsyncClient client;
    private final ListLinuxSubscriptionInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLinuxSubscriptionInstancesPublisher(LicenseManagerLinuxSubscriptionsAsyncClient client, ListLinuxSubscriptionInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLinuxSubscriptionInstancesPublisher(LicenseManagerLinuxSubscriptionsAsyncClient client, ListLinuxSubscriptionInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLinuxSubscriptionInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLinuxSubscriptionInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Instance> instances() {
        Function<ListLinuxSubscriptionInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLinuxSubscriptionInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLinuxSubscriptionInstancesResponseFetcher
    implements AsyncPageFetcher<ListLinuxSubscriptionInstancesResponse> {
        private ListLinuxSubscriptionInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListLinuxSubscriptionInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLinuxSubscriptionInstancesResponse> nextPage(ListLinuxSubscriptionInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListLinuxSubscriptionInstancesPublisher.this.client.listLinuxSubscriptionInstances(ListLinuxSubscriptionInstancesPublisher.this.firstRequest);
            }
            return ListLinuxSubscriptionInstancesPublisher.this.client.listLinuxSubscriptionInstances((ListLinuxSubscriptionInstancesRequest)((Object)ListLinuxSubscriptionInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

