/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntimev2.model.LexRuntimeV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSessionResponse
extends LexRuntimeV2Response
implements ToCopyableBuilder<Builder, PutSessionResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(PutSessionResponse.getter(PutSessionResponse::contentType)).setter(PutSessionResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messages").getter(PutSessionResponse.getter(PutSessionResponse::messages)).setter(PutSessionResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-messages").build()}).build();
    private static final SdkField<String> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionState").getter(PutSessionResponse.getter(PutSessionResponse::sessionState)).setter(PutSessionResponse.setter(Builder::sessionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-state").build()}).build();
    private static final SdkField<String> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestAttributes").getter(PutSessionResponse.getter(PutSessionResponse::requestAttributes)).setter(PutSessionResponse.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-request-attributes").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(PutSessionResponse.getter(PutSessionResponse::sessionId)).setter(PutSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, MESSAGES_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutSessionResponse.memberNameToFieldInitializer();
    private final String contentType;
    private final String messages;
    private final String sessionState;
    private final String requestAttributes;
    private final String sessionId;

    private PutSessionResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.messages = builder.messages;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
        this.sessionId = builder.sessionId;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String messages() {
        return this.messages;
    }

    public final String sessionState() {
        return this.sessionState;
    }

    public final String requestAttributes() {
        return this.requestAttributes;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionResponse)) {
            return false;
        }
        PutSessionResponse other = (PutSessionResponse)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.sessionState(), other.sessionState()) && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"PutSessionResponse").add("ContentType", (Object)this.contentType()).add("Messages", (Object)this.messages()).add("SessionState", (Object)this.sessionState()).add("RequestAttributes", (Object)this.requestAttributes()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("x-amz-lex-messages", MESSAGES_FIELD);
        map.put("x-amz-lex-session-state", SESSION_STATE_FIELD);
        map.put("x-amz-lex-request-attributes", REQUEST_ATTRIBUTES_FIELD);
        map.put("x-amz-lex-session-id", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSessionResponse, T> g) {
        return obj -> g.apply((PutSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeV2Response.BuilderImpl
    implements Builder {
        private String contentType;
        private String messages;
        private String sessionState;
        private String requestAttributes;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSessionResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.messages(model.messages);
            this.sessionState(model.sessionState);
            this.requestAttributes(model.requestAttributes);
            this.sessionId(model.sessionId);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getMessages() {
            return this.messages;
        }

        public final void setMessages(String messages) {
            this.messages = messages;
        }

        @Override
        public final Builder messages(String messages) {
            this.messages = messages;
            return this;
        }

        public final String getSessionState() {
            return this.sessionState;
        }

        public final void setSessionState(String sessionState) {
            this.sessionState = sessionState;
        }

        @Override
        public final Builder sessionState(String sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getRequestAttributes() {
            return this.requestAttributes;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        @Override
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public PutSessionResponse build() {
            return new PutSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexRuntimeV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSessionResponse> {
        public Builder contentType(String var1);

        public Builder messages(String var1);

        public Builder sessionState(String var1);

        public Builder requestAttributes(String var1);

        public Builder sessionId(String var1);
    }
}

