/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexruntimev2.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Value
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Value> {
    private static final SdkField<String> ORIGINAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originalValue").getter(Value.getter(Value::originalValue)).setter(Value.setter(Builder::originalValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originalValue").build()}).build();
    private static final SdkField<String> INTERPRETED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interpretedValue").getter(Value.getter(Value::interpretedValue)).setter(Value.setter(Builder::interpretedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretedValue").build()}).build();
    private static final SdkField<List<String>> RESOLVED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resolvedValues").getter(Value.getter(Value::resolvedValues)).setter(Value.setter(Builder::resolvedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINAL_VALUE_FIELD, INTERPRETED_VALUE_FIELD, RESOLVED_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("originalValue", ORIGINAL_VALUE_FIELD);
            this.put("interpretedValue", INTERPRETED_VALUE_FIELD);
            this.put("resolvedValues", RESOLVED_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String originalValue;
    private final String interpretedValue;
    private final List<String> resolvedValues;

    private Value(BuilderImpl builder) {
        this.originalValue = builder.originalValue;
        this.interpretedValue = builder.interpretedValue;
        this.resolvedValues = builder.resolvedValues;
    }

    public final String originalValue() {
        return this.originalValue;
    }

    public final String interpretedValue() {
        return this.interpretedValue;
    }

    public final boolean hasResolvedValues() {
        return this.resolvedValues != null && !(this.resolvedValues instanceof SdkAutoConstructList);
    }

    public final List<String> resolvedValues() {
        return this.resolvedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.originalValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.interpretedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolvedValues() ? this.resolvedValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value)obj;
        return Objects.equals(this.originalValue(), other.originalValue()) && Objects.equals(this.interpretedValue(), other.interpretedValue()) && this.hasResolvedValues() == other.hasResolvedValues() && Objects.equals(this.resolvedValues(), other.resolvedValues());
    }

    public final String toString() {
        return ToString.builder((String)"Value").add("OriginalValue", (Object)this.originalValue()).add("InterpretedValue", (Object)this.interpretedValue()).add("ResolvedValues", this.hasResolvedValues() ? this.resolvedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "originalValue": {
                return Optional.ofNullable(clazz.cast(this.originalValue()));
            }
            case "interpretedValue": {
                return Optional.ofNullable(clazz.cast(this.interpretedValue()));
            }
            case "resolvedValues": {
                return Optional.ofNullable(clazz.cast(this.resolvedValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Value, T> g) {
        return obj -> g.apply((Value)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String originalValue;
        private String interpretedValue;
        private List<String> resolvedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Value model) {
            this.originalValue(model.originalValue);
            this.interpretedValue(model.interpretedValue);
            this.resolvedValues(model.resolvedValues);
        }

        public final String getOriginalValue() {
            return this.originalValue;
        }

        public final void setOriginalValue(String originalValue) {
            this.originalValue = originalValue;
        }

        @Override
        public final Builder originalValue(String originalValue) {
            this.originalValue = originalValue;
            return this;
        }

        public final String getInterpretedValue() {
            return this.interpretedValue;
        }

        public final void setInterpretedValue(String interpretedValue) {
            this.interpretedValue = interpretedValue;
        }

        @Override
        public final Builder interpretedValue(String interpretedValue) {
            this.interpretedValue = interpretedValue;
            return this;
        }

        public final Collection<String> getResolvedValues() {
            if (this.resolvedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resolvedValues;
        }

        public final void setResolvedValues(Collection<String> resolvedValues) {
            this.resolvedValues = StringListCopier.copy(resolvedValues);
        }

        @Override
        public final Builder resolvedValues(Collection<String> resolvedValues) {
            this.resolvedValues = StringListCopier.copy(resolvedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedValues(String ... resolvedValues) {
            this.resolvedValues(Arrays.asList(resolvedValues));
            return this;
        }

        public Value build() {
            return new Value(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Value> {
        public Builder originalValue(String var1);

        public Builder interpretedValue(String var1);

        public Builder resolvedValues(Collection<String> var1);

        public Builder resolvedValues(String ... var1);
    }
}

