/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequestEventStream;

/**
 * A specialization of {@code software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent} that represents the
 * {@code StartConversationRequestEventStream$AudioInputEvent} event. Do not use this class directly. Instead, use the
 * static builder methods on
 * {@link software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequestEventStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultAudioInputEvent extends AudioInputEvent {
    private static final long serialVersionUID = 1L;

    DefaultAudioInputEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public StartConversationRequestEventStream.EventType sdkEventType() {
        return StartConversationRequestEventStream.EventType.AUDIO_INPUT_EVENT;
    }

    public interface Builder extends AudioInputEvent.Builder {
        @Override
        DefaultAudioInputEvent build();
    }

    private static final class BuilderImpl extends AudioInputEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultAudioInputEvent event) {
            super(event);
        }

        @Override
        public DefaultAudioInputEvent build() {
            return new DefaultAudioInputEvent(this);
        }
    }
}
