/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConversationRequest extends LexRuntimeV2Request implements
        ToCopyableBuilder<StartConversationRequest.Builder, StartConversationRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(StartConversationRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(StartConversationRequest::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(StartConversationRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(StartConversationRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> CONVERSATION_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("conversationMode")
            .getter(getter(StartConversationRequest::conversationModeAsString))
            .setter(setter(Builder::conversationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-conversation-mode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, CONVERSATION_MODE_FIELD));

    private final String botId;

    private final String botAliasId;

    private final String localeId;

    private final String sessionId;

    private final String conversationMode;

    private StartConversationRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.conversationMode = builder.conversationMode;
    }

    /**
     * <p>
     * The identifier of the bot to process the request.
     * </p>
     * 
     * @return The identifier of the bot to process the request.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The alias identifier in use for the bot that processes the request.
     * </p>
     * 
     * @return The alias identifier in use for the bot that processes the request.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The locale where the session is in use.
     * </p>
     * 
     * @return The locale where the session is in use.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The identifier of the user session that is having the conversation.
     * </p>
     * 
     * @return The identifier of the user session that is having the conversation.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The conversation type that you are using the Amazon Lex V2. If the conversation mode is <code>AUDIO</code> you
     * can send both audio and DTMF information. If the mode is <code>TEXT</code> you can only send text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conversationMode}
     * will return {@link ConversationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #conversationModeAsString}.
     * </p>
     * 
     * @return The conversation type that you are using the Amazon Lex V2. If the conversation mode is
     *         <code>AUDIO</code> you can send both audio and DTMF information. If the mode is <code>TEXT</code> you can
     *         only send text.
     * @see ConversationMode
     */
    public final ConversationMode conversationMode() {
        return ConversationMode.fromValue(conversationMode);
    }

    /**
     * <p>
     * The conversation type that you are using the Amazon Lex V2. If the conversation mode is <code>AUDIO</code> you
     * can send both audio and DTMF information. If the mode is <code>TEXT</code> you can only send text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conversationMode}
     * will return {@link ConversationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #conversationModeAsString}.
     * </p>
     * 
     * @return The conversation type that you are using the Amazon Lex V2. If the conversation mode is
     *         <code>AUDIO</code> you can send both audio and DTMF information. If the mode is <code>TEXT</code> you can
     *         only send text.
     * @see ConversationMode
     */
    public final String conversationModeAsString() {
        return conversationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(conversationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConversationRequest)) {
            return false;
        }
        StartConversationRequest other = (StartConversationRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(conversationModeAsString(), other.conversationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConversationRequest").add("BotId", botId()).add("BotAliasId", botAliasId())
                .add("LocaleId", localeId()).add("SessionId", sessionId()).add("ConversationMode", conversationModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "conversationMode":
            return Optional.ofNullable(clazz.cast(conversationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConversationRequest, T> g) {
        return obj -> g.apply((StartConversationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeV2Request.Builder, SdkPojo, CopyableBuilder<Builder, StartConversationRequest> {
        /**
         * <p>
         * The identifier of the bot to process the request.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot to process the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The alias identifier in use for the bot that processes the request.
         * </p>
         * 
         * @param botAliasId
         *        The alias identifier in use for the bot that processes the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The locale where the session is in use.
         * </p>
         * 
         * @param localeId
         *        The locale where the session is in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The identifier of the user session that is having the conversation.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the user session that is having the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The conversation type that you are using the Amazon Lex V2. If the conversation mode is <code>AUDIO</code>
         * you can send both audio and DTMF information. If the mode is <code>TEXT</code> you can only send text.
         * </p>
         * 
         * @param conversationMode
         *        The conversation type that you are using the Amazon Lex V2. If the conversation mode is
         *        <code>AUDIO</code> you can send both audio and DTMF information. If the mode is <code>TEXT</code> you
         *        can only send text.
         * @see ConversationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversationMode
         */
        Builder conversationMode(String conversationMode);

        /**
         * <p>
         * The conversation type that you are using the Amazon Lex V2. If the conversation mode is <code>AUDIO</code>
         * you can send both audio and DTMF information. If the mode is <code>TEXT</code> you can only send text.
         * </p>
         * 
         * @param conversationMode
         *        The conversation type that you are using the Amazon Lex V2. If the conversation mode is
         *        <code>AUDIO</code> you can send both audio and DTMF information. If the mode is <code>TEXT</code> you
         *        can only send text.
         * @see ConversationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversationMode
         */
        Builder conversationMode(ConversationMode conversationMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String localeId;

        private String sessionId;

        private String conversationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConversationRequest model) {
            super(model);
            botId(model.botId);
            botAliasId(model.botAliasId);
            localeId(model.localeId);
            sessionId(model.sessionId);
            conversationMode(model.conversationMode);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getConversationMode() {
            return conversationMode;
        }

        public final void setConversationMode(String conversationMode) {
            this.conversationMode = conversationMode;
        }

        @Override
        public final Builder conversationMode(String conversationMode) {
            this.conversationMode = conversationMode;
            return this;
        }

        @Override
        public final Builder conversationMode(ConversationMode conversationMode) {
            this.conversationMode(conversationMode == null ? null : conversationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConversationRequest build() {
            return new StartConversationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
