/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lexruntimev2.DefaultLexRuntimeV2BaseClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.DefaultLexRuntimeV2Client;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2Client;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2ClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2ServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntimev2.endpoints.LexRuntimeV2EndpointProvider;

@SdkInternalApi
final class DefaultLexRuntimeV2ClientBuilder
extends DefaultLexRuntimeV2BaseClientBuilder<LexRuntimeV2ClientBuilder, LexRuntimeV2Client>
implements LexRuntimeV2ClientBuilder {
    DefaultLexRuntimeV2ClientBuilder() {
    }

    @Override
    public DefaultLexRuntimeV2ClientBuilder endpointProvider(LexRuntimeV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LexRuntimeV2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLexRuntimeV2ClientBuilder.validateClientOptions(clientConfiguration);
        LexRuntimeV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLexRuntimeV2Client client = new DefaultLexRuntimeV2Client(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LexRuntimeV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LexRuntimeV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

