/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntimev2.model.Message;
import software.amazon.awssdk.services.lexruntimev2.model.MessagesCopier;
import software.amazon.awssdk.services.lexruntimev2.model.SessionState;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequestEventStream;
import software.amazon.awssdk.services.lexruntimev2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationEvent>,
StartConversationRequestEventStream {
    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestAttributes").getter(ConfigurationEvent.getter(ConfigurationEvent::requestAttributes)).setter(ConfigurationEvent.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESPONSE_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseContentType").getter(ConfigurationEvent.getter(ConfigurationEvent::responseContentType)).setter(ConfigurationEvent.setter(Builder::responseContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseContentType").build()}).build();
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(ConfigurationEvent.getter(ConfigurationEvent::sessionState)).setter(ConfigurationEvent.setter(Builder::sessionState)).constructor(SessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final SdkField<List<Message>> WELCOME_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("welcomeMessages").getter(ConfigurationEvent.getter(ConfigurationEvent::welcomeMessages)).setter(ConfigurationEvent.setter(Builder::welcomeMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DISABLE_PLAYBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("disablePlayback").getter(ConfigurationEvent.getter(ConfigurationEvent::disablePlayback)).setter(ConfigurationEvent.setter(Builder::disablePlayback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disablePlayback").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(ConfigurationEvent.getter(ConfigurationEvent::eventId)).setter(ConfigurationEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<Long> CLIENT_TIMESTAMP_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("clientTimestampMillis").getter(ConfigurationEvent.getter(ConfigurationEvent::clientTimestampMillis)).setter(ConfigurationEvent.setter(Builder::clientTimestampMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientTimestampMillis").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ATTRIBUTES_FIELD, RESPONSE_CONTENT_TYPE_FIELD, SESSION_STATE_FIELD, WELCOME_MESSAGES_FIELD, DISABLE_PLAYBACK_FIELD, EVENT_ID_FIELD, CLIENT_TIMESTAMP_MILLIS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> requestAttributes;
    private final String responseContentType;
    private final SessionState sessionState;
    private final List<Message> welcomeMessages;
    private final Boolean disablePlayback;
    private final String eventId;
    private final Long clientTimestampMillis;

    protected ConfigurationEvent(BuilderImpl builder) {
        this.requestAttributes = builder.requestAttributes;
        this.responseContentType = builder.responseContentType;
        this.sessionState = builder.sessionState;
        this.welcomeMessages = builder.welcomeMessages;
        this.disablePlayback = builder.disablePlayback;
        this.eventId = builder.eventId;
        this.clientTimestampMillis = builder.clientTimestampMillis;
    }

    public final boolean hasRequestAttributes() {
        return this.requestAttributes != null && !(this.requestAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestAttributes() {
        return this.requestAttributes;
    }

    public final String responseContentType() {
        return this.responseContentType;
    }

    public final SessionState sessionState() {
        return this.sessionState;
    }

    public final boolean hasWelcomeMessages() {
        return this.welcomeMessages != null && !(this.welcomeMessages instanceof SdkAutoConstructList);
    }

    public final List<Message> welcomeMessages() {
        return this.welcomeMessages;
    }

    public final Boolean disablePlayback() {
        return this.disablePlayback;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final Long clientTimestampMillis() {
        return this.clientTimestampMillis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestAttributes() ? this.requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseContentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWelcomeMessages() ? this.welcomeMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.disablePlayback());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientTimestampMillis());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent)obj;
        return this.hasRequestAttributes() == other.hasRequestAttributes() && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.responseContentType(), other.responseContentType()) && Objects.equals(this.sessionState(), other.sessionState()) && this.hasWelcomeMessages() == other.hasWelcomeMessages() && Objects.equals(this.welcomeMessages(), other.welcomeMessages()) && Objects.equals(this.disablePlayback(), other.disablePlayback()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.clientTimestampMillis(), other.clientTimestampMillis());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationEvent").add("RequestAttributes", this.hasRequestAttributes() ? this.requestAttributes() : null).add("ResponseContentType", (Object)this.responseContentType()).add("SessionState", (Object)this.sessionState()).add("WelcomeMessages", this.hasWelcomeMessages() ? this.welcomeMessages() : null).add("DisablePlayback", (Object)this.disablePlayback()).add("EventId", (Object)this.eventId()).add("ClientTimestampMillis", (Object)this.clientTimestampMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "responseContentType": {
                return Optional.ofNullable(clazz.cast(this.responseContentType()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "welcomeMessages": {
                return Optional.ofNullable(clazz.cast(this.welcomeMessages()));
            }
            case "disablePlayback": {
                return Optional.ofNullable(clazz.cast(this.disablePlayback()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "clientTimestampMillis": {
                return Optional.ofNullable(clazz.cast(this.clientTimestampMillis()));
            }
        }
        return Optional.empty();
    }

    public final ConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return (ConfigurationEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    protected static class BuilderImpl
    implements Builder {
        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String responseContentType;
        private SessionState sessionState;
        private List<Message> welcomeMessages = DefaultSdkAutoConstructList.getInstance();
        private Boolean disablePlayback;
        private String eventId;
        private Long clientTimestampMillis;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConfigurationEvent model) {
            this.requestAttributes(model.requestAttributes);
            this.responseContentType(model.responseContentType);
            this.sessionState(model.sessionState);
            this.welcomeMessages(model.welcomeMessages);
            this.disablePlayback(model.disablePlayback);
            this.eventId(model.eventId);
            this.clientTimestampMillis(model.clientTimestampMillis);
        }

        public final Map<String, String> getRequestAttributes() {
            if (this.requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        @Transient
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final String getResponseContentType() {
            return this.responseContentType;
        }

        public final void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @Override
        @Transient
        public final Builder responseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        @Transient
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final List<Message.Builder> getWelcomeMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.welcomeMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWelcomeMessages(Collection<Message.BuilderImpl> welcomeMessages) {
            this.welcomeMessages = MessagesCopier.copyFromBuilder(welcomeMessages);
        }

        @Override
        @Transient
        public final Builder welcomeMessages(Collection<Message> welcomeMessages) {
            this.welcomeMessages = MessagesCopier.copy(welcomeMessages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder welcomeMessages(Message ... welcomeMessages) {
            this.welcomeMessages(Arrays.asList(welcomeMessages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder welcomeMessages(Consumer<Message.Builder> ... welcomeMessages) {
            this.welcomeMessages(Stream.of(welcomeMessages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDisablePlayback() {
            return this.disablePlayback;
        }

        public final void setDisablePlayback(Boolean disablePlayback) {
            this.disablePlayback = disablePlayback;
        }

        @Override
        @Transient
        public final Builder disablePlayback(Boolean disablePlayback) {
            this.disablePlayback = disablePlayback;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        @Transient
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Long getClientTimestampMillis() {
            return this.clientTimestampMillis;
        }

        public final void setClientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
        }

        @Override
        @Transient
        public final Builder clientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
            return this;
        }

        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationEvent> {
        public Builder requestAttributes(Map<String, String> var1);

        public Builder responseContentType(String var1);

        public Builder sessionState(SessionState var1);

        default public Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return this.sessionState((SessionState)((SessionState.Builder)SessionState.builder().applyMutation(sessionState)).build());
        }

        public Builder welcomeMessages(Collection<Message> var1);

        public Builder welcomeMessages(Message ... var1);

        public Builder welcomeMessages(Consumer<Message.Builder> ... var1);

        public Builder disablePlayback(Boolean var1);

        public Builder eventId(String var1);

        public Builder clientTimestampMillis(Long var1);
    }
}

