/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntimev2.model.SentimentScore;
import software.amazon.awssdk.services.lexruntimev2.model.SentimentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SentimentResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SentimentResponse> {
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sentiment").getter(SentimentResponse.getter(SentimentResponse::sentimentAsString)).setter(SentimentResponse.setter(Builder::sentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentiment").build()}).build();
    private static final SdkField<SentimentScore> SENTIMENT_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sentimentScore").getter(SentimentResponse.getter(SentimentResponse::sentimentScore)).setter(SentimentResponse.setter(Builder::sentimentScore)).constructor(SentimentScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENTIMENT_FIELD, SENTIMENT_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sentiment;
    private final SentimentScore sentimentScore;

    private SentimentResponse(BuilderImpl builder) {
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    public final SentimentType sentiment() {
        return SentimentType.fromValue(this.sentiment);
    }

    public final String sentimentAsString() {
        return this.sentiment;
    }

    public final SentimentScore sentimentScore() {
        return this.sentimentScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentResponse)) {
            return false;
        }
        SentimentResponse other = (SentimentResponse)obj;
        return Objects.equals(this.sentimentAsString(), other.sentimentAsString()) && Objects.equals(this.sentimentScore(), other.sentimentScore());
    }

    public final String toString() {
        return ToString.builder((String)"SentimentResponse").add("Sentiment", (Object)this.sentimentAsString()).add("SentimentScore", (Object)this.sentimentScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sentiment": {
                return Optional.ofNullable(clazz.cast(this.sentimentAsString()));
            }
            case "sentimentScore": {
                return Optional.ofNullable(clazz.cast(this.sentimentScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SentimentResponse, T> g) {
        return obj -> g.apply((SentimentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sentiment;
        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(SentimentResponse model) {
            this.sentiment(model.sentiment);
            this.sentimentScore(model.sentimentScore);
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return this.sentimentScore != null ? this.sentimentScore.toBuilder() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        public SentimentResponse build() {
            return new SentimentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SentimentResponse> {
        public Builder sentiment(String var1);

        public Builder sentiment(SentimentType var1);

        public Builder sentimentScore(SentimentScore var1);

        default public Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return this.sentimentScore((SentimentScore)((SentimentScore.Builder)SentimentScore.builder().applyMutation(sentimentScore)).build());
        }
    }
}

