/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntimev2.model.ConversationMode;
import software.amazon.awssdk.services.lexruntimev2.model.LexRuntimeV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartConversationRequest
extends LexRuntimeV2Request
implements ToCopyableBuilder<Builder, StartConversationRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(StartConversationRequest.getter(StartConversationRequest::botId)).setter(StartConversationRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(StartConversationRequest.getter(StartConversationRequest::botAliasId)).setter(StartConversationRequest.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(StartConversationRequest.getter(StartConversationRequest::localeId)).setter(StartConversationRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(StartConversationRequest.getter(StartConversationRequest::sessionId)).setter(StartConversationRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> CONVERSATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationMode").getter(StartConversationRequest.getter(StartConversationRequest::conversationModeAsString)).setter(StartConversationRequest.setter(Builder::conversationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-conversation-mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, CONVERSATION_MODE_FIELD));
    private final String botId;
    private final String botAliasId;
    private final String localeId;
    private final String sessionId;
    private final String conversationMode;

    private StartConversationRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.conversationMode = builder.conversationMode;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final ConversationMode conversationMode() {
        return ConversationMode.fromValue(this.conversationMode);
    }

    public final String conversationModeAsString() {
        return this.conversationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConversationRequest)) {
            return false;
        }
        StartConversationRequest other = (StartConversationRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.conversationModeAsString(), other.conversationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartConversationRequest").add("BotId", (Object)this.botId()).add("BotAliasId", (Object)this.botAliasId()).add("LocaleId", (Object)this.localeId()).add("SessionId", (Object)this.sessionId()).add("ConversationMode", (Object)this.conversationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "conversationMode": {
                return Optional.ofNullable(clazz.cast(this.conversationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConversationRequest, T> g) {
        return obj -> g.apply((StartConversationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botAliasId;
        private String localeId;
        private String sessionId;
        private String conversationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConversationRequest model) {
            super(model);
            this.botId(model.botId);
            this.botAliasId(model.botAliasId);
            this.localeId(model.localeId);
            this.sessionId(model.sessionId);
            this.conversationMode(model.conversationMode);
        }

        public final String getBotId() {
            return this.botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getConversationMode() {
            return this.conversationMode;
        }

        @Override
        public final Builder conversationMode(String conversationMode) {
            this.conversationMode = conversationMode;
            return this;
        }

        @Override
        public final Builder conversationMode(ConversationMode conversationMode) {
            this.conversationMode(conversationMode == null ? null : conversationMode.toString());
            return this;
        }

        public final void setConversationMode(String conversationMode) {
            this.conversationMode = conversationMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConversationRequest build() {
            return new StartConversationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartConversationRequest> {
        public Builder botId(String var1);

        public Builder botAliasId(String var1);

        public Builder localeId(String var1);

        public Builder sessionId(String var1);

        public Builder conversationMode(String var1);

        public Builder conversationMode(ConversationMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

