/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationEventMarshaller
implements Marshaller<ConfigurationEvent> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().hasExplicitPayloadMember(false).hasPayloadMembers(true).httpMethod(SdkHttpMethod.GET).hasEvent(true).build();
    private final BaseAwsJsonProtocolFactory protocolFactory;

    public ConfigurationEventMarshaller(BaseAwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public SdkHttpFullRequest marshall(ConfigurationEvent configurationEvent) {
        Validate.paramNotNull((Object)configurationEvent, (String)"configurationEvent");
        try {
            ProtocolMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING);
            return ((SdkHttpFullRequest)protocolMarshaller.marshall((SdkPojo)configurationEvent)).toBuilder().putHeader(":message-type", "event").putHeader(":event-type", configurationEvent.sdkEventType().toString()).putHeader(":content-type", "application/json").build();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

