/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent;
import software.amazon.awssdk.services.lexruntimev2.model.DTMFInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.DisconnectionEvent;
import software.amazon.awssdk.services.lexruntimev2.model.PlaybackCompletionEvent;
import software.amazon.awssdk.services.lexruntimev2.model.TextInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultAudioInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultConfigurationEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultDTMFInputEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultDisconnectionEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultPlaybackCompletionEvent;
import software.amazon.awssdk.services.lexruntimev2.model.startconversationrequesteventstream.DefaultTextInputEvent;

@SdkPublicApi
public interface StartConversationRequestEventStream {
    public static ConfigurationEvent.Builder configurationEventBuilder() {
        return DefaultConfigurationEvent.builder();
    }

    public static AudioInputEvent.Builder audioInputEventBuilder() {
        return DefaultAudioInputEvent.builder();
    }

    public static DTMFInputEvent.Builder dTMFInputEventBuilder() {
        return DefaultDTMFInputEvent.builder();
    }

    public static TextInputEvent.Builder textInputEventBuilder() {
        return DefaultTextInputEvent.builder();
    }

    public static PlaybackCompletionEvent.Builder playbackCompletionEventBuilder() {
        return DefaultPlaybackCompletionEvent.builder();
    }

    public static DisconnectionEvent.Builder disconnectionEventBuilder() {
        return DefaultDisconnectionEvent.builder();
    }

    default public EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    public static enum EventType {
        CONFIGURATION_EVENT("ConfigurationEvent"),
        AUDIO_INPUT_EVENT("AudioInputEvent"),
        DTMF_INPUT_EVENT("DTMFInputEvent"),
        TEXT_INPUT_EVENT("TextInputEvent"),
        PLAYBACK_COMPLETION_EVENT("PlaybackCompletionEvent"),
        DISCONNECTION_EVENT("DisconnectionEvent"),
        UNKNOWN_TO_SDK_VERSION(null);

        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
        }

        public static Set<EventType> knownValues() {
            return Stream.of(EventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
        }
    }
}

