/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntimev2.model.InputMode;
import software.amazon.awssdk.services.lexruntimev2.model.Interpretation;
import software.amazon.awssdk.services.lexruntimev2.model.InterpretationsCopier;
import software.amazon.awssdk.services.lexruntimev2.model.SessionState;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseEventStream;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseHandler;
import software.amazon.awssdk.services.lexruntimev2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IntentResultEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntentResultEvent>,
StartConversationResponseEventStream {
    private static final SdkField<String> INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputMode").getter(IntentResultEvent.getter(IntentResultEvent::inputModeAsString)).setter(IntentResultEvent.setter(Builder::inputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputMode").build()}).build();
    private static final SdkField<List<Interpretation>> INTERPRETATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("interpretations").getter(IntentResultEvent.getter(IntentResultEvent::interpretations)).setter(IntentResultEvent.setter(Builder::interpretations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Interpretation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(IntentResultEvent.getter(IntentResultEvent::sessionState)).setter(IntentResultEvent.setter(Builder::sessionState)).constructor(SessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestAttributes").getter(IntentResultEvent.getter(IntentResultEvent::requestAttributes)).setter(IntentResultEvent.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(IntentResultEvent.getter(IntentResultEvent::sessionId)).setter(IntentResultEvent.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(IntentResultEvent.getter(IntentResultEvent::eventId)).setter(IntentResultEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_MODE_FIELD, INTERPRETATIONS_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD, SESSION_ID_FIELD, EVENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputMode;
    private final List<Interpretation> interpretations;
    private final SessionState sessionState;
    private final Map<String, String> requestAttributes;
    private final String sessionId;
    private final String eventId;

    protected IntentResultEvent(BuilderImpl builder) {
        this.inputMode = builder.inputMode;
        this.interpretations = builder.interpretations;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
        this.sessionId = builder.sessionId;
        this.eventId = builder.eventId;
    }

    public final InputMode inputMode() {
        return InputMode.fromValue(this.inputMode);
    }

    public final String inputModeAsString() {
        return this.inputMode;
    }

    public final boolean hasInterpretations() {
        return this.interpretations != null && !(this.interpretations instanceof SdkAutoConstructList);
    }

    public final List<Interpretation> interpretations() {
        return this.interpretations;
    }

    public final SessionState sessionState() {
        return this.sessionState;
    }

    public final boolean hasRequestAttributes() {
        return this.requestAttributes != null && !(this.requestAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestAttributes() {
        return this.requestAttributes;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInterpretations() ? this.interpretations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestAttributes() ? this.requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentResultEvent)) {
            return false;
        }
        IntentResultEvent other = (IntentResultEvent)obj;
        return Objects.equals(this.inputModeAsString(), other.inputModeAsString()) && this.hasInterpretations() == other.hasInterpretations() && Objects.equals(this.interpretations(), other.interpretations()) && Objects.equals(this.sessionState(), other.sessionState()) && this.hasRequestAttributes() == other.hasRequestAttributes() && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.eventId(), other.eventId());
    }

    public final String toString() {
        return ToString.builder((String)"IntentResultEvent").add("InputMode", (Object)this.inputModeAsString()).add("Interpretations", this.hasInterpretations() ? this.interpretations() : null).add("SessionState", (Object)this.sessionState()).add("RequestAttributes", this.hasRequestAttributes() ? this.requestAttributes() : null).add("SessionId", (Object)this.sessionId()).add("EventId", (Object)this.eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputMode": {
                return Optional.ofNullable(clazz.cast(this.inputModeAsString()));
            }
            case "interpretations": {
                return Optional.ofNullable(clazz.cast(this.interpretations()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
        }
        return Optional.empty();
    }

    public final IntentResultEvent copy(Consumer<? super Builder> modifier) {
        return (IntentResultEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentResultEvent, T> g) {
        return obj -> g.apply((IntentResultEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(StartConversationResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String inputMode;
        private List<Interpretation> interpretations = DefaultSdkAutoConstructList.getInstance();
        private SessionState sessionState;
        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String sessionId;
        private String eventId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(IntentResultEvent model) {
            this.inputMode(model.inputMode);
            this.interpretations(model.interpretations);
            this.sessionState(model.sessionState);
            this.requestAttributes(model.requestAttributes);
            this.sessionId(model.sessionId);
            this.eventId(model.eventId);
        }

        public final String getInputMode() {
            return this.inputMode;
        }

        @Override
        public final Builder inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        @Override
        public final Builder inputMode(InputMode inputMode) {
            this.inputMode(inputMode == null ? null : inputMode.toString());
            return this;
        }

        public final void setInputMode(String inputMode) {
            this.inputMode = inputMode;
        }

        public final List<Interpretation.Builder> getInterpretations() {
            List<Interpretation.Builder> result = InterpretationsCopier.copyToBuilder(this.interpretations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder interpretations(Collection<Interpretation> interpretations) {
            this.interpretations = InterpretationsCopier.copy(interpretations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interpretations(Interpretation ... interpretations) {
            this.interpretations(Arrays.asList(interpretations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interpretations(Consumer<Interpretation.Builder> ... interpretations) {
            this.interpretations(Stream.of(interpretations).map(c -> (Interpretation)((Interpretation.Builder)Interpretation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInterpretations(Collection<Interpretation.BuilderImpl> interpretations) {
            this.interpretations = InterpretationsCopier.copyFromBuilder(interpretations);
        }

        public final SessionState.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        public final Map<String, String> getRequestAttributes() {
            if (this.requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestAttributes;
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public IntentResultEvent build() {
            return new IntentResultEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntentResultEvent> {
        public Builder inputMode(String var1);

        public Builder inputMode(InputMode var1);

        public Builder interpretations(Collection<Interpretation> var1);

        public Builder interpretations(Interpretation ... var1);

        public Builder interpretations(Consumer<Interpretation.Builder> ... var1);

        public Builder sessionState(SessionState var1);

        default public Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return this.sessionState((SessionState)((SessionState.Builder)SessionState.builder().applyMutation(sessionState)).build());
        }

        public Builder requestAttributes(Map<String, String> var1);

        public Builder sessionId(String var1);

        public Builder eventId(String var1);
    }
}

