/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lexruntimev2.DefaultLexRuntimeV2ClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2ClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.model.AccessDeniedException;
import software.amazon.awssdk.services.lexruntimev2.model.BadGatewayException;
import software.amazon.awssdk.services.lexruntimev2.model.ConflictException;
import software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionRequest;
import software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse;
import software.amazon.awssdk.services.lexruntimev2.model.DependencyFailedException;
import software.amazon.awssdk.services.lexruntimev2.model.GetSessionRequest;
import software.amazon.awssdk.services.lexruntimev2.model.GetSessionResponse;
import software.amazon.awssdk.services.lexruntimev2.model.InternalServerException;
import software.amazon.awssdk.services.lexruntimev2.model.LexRuntimeV2Exception;
import software.amazon.awssdk.services.lexruntimev2.model.PutSessionRequest;
import software.amazon.awssdk.services.lexruntimev2.model.PutSessionResponse;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextRequest;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceRequest;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse;
import software.amazon.awssdk.services.lexruntimev2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lexruntimev2.model.ThrottlingException;
import software.amazon.awssdk.services.lexruntimev2.model.ValidationException;

public interface LexRuntimeV2Client
extends SdkClient {
    public static final String SERVICE_NAME = "lex";

    public static LexRuntimeV2Client create() {
        return (LexRuntimeV2Client)LexRuntimeV2Client.builder().build();
    }

    public static LexRuntimeV2ClientBuilder builder() {
        return new DefaultLexRuntimeV2ClientBuilder();
    }

    default public DeleteSessionResponse deleteSession(DeleteSessionRequest deleteSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        throw new UnsupportedOperationException();
    }

    default public DeleteSessionResponse deleteSession(Consumer<DeleteSessionRequest.Builder> deleteSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.deleteSession((DeleteSessionRequest)((Object)((DeleteSessionRequest.Builder)DeleteSessionRequest.builder().applyMutation(deleteSessionRequest)).build()));
    }

    default public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        throw new UnsupportedOperationException();
    }

    default public GetSessionResponse getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.getSession((GetSessionRequest)((Object)((GetSessionRequest.Builder)GetSessionRequest.builder().applyMutation(getSessionRequest)).build()));
    }

    default public <ReturnT> ReturnT putSession(PutSessionRequest putSessionRequest, ResponseTransformer<PutSessionResponse, ReturnT> responseTransformer) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, ResponseTransformer<PutSessionResponse, ReturnT> responseTransformer) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), responseTransformer);
    }

    default public PutSessionResponse putSession(PutSessionRequest putSessionRequest, Path destinationPath) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return (PutSessionResponse)((Object)this.putSession(putSessionRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public PutSessionResponse putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, Path destinationPath) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<PutSessionResponse> putSession(PutSessionRequest putSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return (ResponseInputStream)this.putSession(putSessionRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<PutSessionResponse> putSession(Consumer<PutSessionRequest.Builder> putSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()));
    }

    default public ResponseBytes<PutSessionResponse> putSessionAsBytes(PutSessionRequest putSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return (ResponseBytes)this.putSession(putSessionRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<PutSessionResponse> putSessionAsBytes(Consumer<PutSessionRequest.Builder> putSessionRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.putSessionAsBytes((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()));
    }

    default public RecognizeTextResponse recognizeText(RecognizeTextRequest recognizeTextRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        throw new UnsupportedOperationException();
    }

    default public RecognizeTextResponse recognizeText(Consumer<RecognizeTextRequest.Builder> recognizeTextRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.recognizeText((RecognizeTextRequest)((Object)((RecognizeTextRequest.Builder)RecognizeTextRequest.builder().applyMutation(recognizeTextRequest)).build()));
    }

    default public <ReturnT> ReturnT recognizeUtterance(RecognizeUtteranceRequest recognizeUtteranceRequest, RequestBody requestBody, ResponseTransformer<RecognizeUtteranceResponse, ReturnT> responseTransformer) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT recognizeUtterance(Consumer<RecognizeUtteranceRequest.Builder> recognizeUtteranceRequest, RequestBody requestBody, ResponseTransformer<RecognizeUtteranceResponse, ReturnT> responseTransformer) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.recognizeUtterance((RecognizeUtteranceRequest)((Object)((RecognizeUtteranceRequest.Builder)RecognizeUtteranceRequest.builder().applyMutation(recognizeUtteranceRequest)).build()), requestBody, responseTransformer);
    }

    default public RecognizeUtteranceResponse recognizeUtterance(RecognizeUtteranceRequest recognizeUtteranceRequest, Path sourcePath, Path destinationPath) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return (RecognizeUtteranceResponse)((Object)this.recognizeUtterance(recognizeUtteranceRequest, RequestBody.fromFile((Path)sourcePath), ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public RecognizeUtteranceResponse recognizeUtterance(Consumer<RecognizeUtteranceRequest.Builder> recognizeUtteranceRequest, Path sourcePath, Path destinationPath) throws AccessDeniedException, ResourceNotFoundException, ValidationException, ThrottlingException, InternalServerException, ConflictException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeV2Exception {
        return this.recognizeUtterance((RecognizeUtteranceRequest)((Object)((RecognizeUtteranceRequest.Builder)RecognizeUtteranceRequest.builder().applyMutation(recognizeUtteranceRequest)).build()), sourcePath, destinationPath);
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"runtime-v2-lex");
    }
}

