/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DialogActionType {
    ELICIT_INTENT("ElicitIntent"),
    CONFIRM_INTENT("ConfirmIntent"),
    ELICIT_SLOT("ElicitSlot"),
    CLOSE("Close"),
    DELEGATE("Delegate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DialogActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DialogActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DialogActionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DialogActionType> knownValues() {
        return Stream.of(DialogActionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

