/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DialogActionType {
    ELICIT_INTENT("ElicitIntent"),
    CONFIRM_INTENT("ConfirmIntent"),
    ELICIT_SLOT("ElicitSlot"),
    CLOSE("Close"),
    DELEGATE("Delegate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DialogActionType> VALUE_MAP;
    private final String value;

    private DialogActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DialogActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DialogActionType> knownValues() {
        EnumSet<DialogActionType> knownValues = EnumSet.allOf(DialogActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DialogActionType.class, DialogActionType::toString);
    }
}

