/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfirmationStatus {
    NONE("None"),
    CONFIRMED("Confirmed"),
    DENIED("Denied"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfirmationStatus> VALUE_MAP;
    private final String value;

    private ConfirmationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfirmationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfirmationStatus> knownValues() {
        EnumSet<ConfirmationStatus> knownValues = EnumSet.allOf(ConfirmationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfirmationStatus.class, ConfirmationStatus::toString);
    }
}

