/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.ActiveContext;
import software.amazon.awssdk.services.lexruntime.model.ActiveContextsListCopier;
import software.amazon.awssdk.services.lexruntime.model.DialogState;
import software.amazon.awssdk.services.lexruntime.model.IntentConfidence;
import software.amazon.awssdk.services.lexruntime.model.IntentListCopier;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeResponse;
import software.amazon.awssdk.services.lexruntime.model.MessageFormatType;
import software.amazon.awssdk.services.lexruntime.model.PredictedIntent;
import software.amazon.awssdk.services.lexruntime.model.ResponseCard;
import software.amazon.awssdk.services.lexruntime.model.SentimentResponse;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostTextResponse
extends LexRuntimeResponse
implements ToCopyableBuilder<Builder, PostTextResponse> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(PostTextResponse.getter(PostTextResponse::intentName)).setter(PostTextResponse.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<IntentConfidence> NLU_INTENT_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nluIntentConfidence").getter(PostTextResponse.getter(PostTextResponse::nluIntentConfidence)).setter(PostTextResponse.setter(Builder::nluIntentConfidence)).constructor(IntentConfidence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidence").build()}).build();
    private static final SdkField<List<PredictedIntent>> ALTERNATIVE_INTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alternativeIntents").getter(PostTextResponse.getter(PostTextResponse::alternativeIntents)).setter(PostTextResponse.setter(Builder::alternativeIntents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternativeIntents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictedIntent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("slots").getter(PostTextResponse.getter(PostTextResponse::slots)).setter(PostTextResponse.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(PostTextResponse.getter(PostTextResponse::sessionAttributes)).setter(PostTextResponse.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(PostTextResponse.getter(PostTextResponse::message)).setter(PostTextResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<SentimentResponse> SENTIMENT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sentimentResponse").getter(PostTextResponse.getter(PostTextResponse::sentimentResponse)).setter(PostTextResponse.setter(Builder::sentimentResponse)).constructor(SentimentResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentResponse").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageFormat").getter(PostTextResponse.getter(PostTextResponse::messageFormatAsString)).setter(PostTextResponse.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageFormat").build()}).build();
    private static final SdkField<String> DIALOG_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dialogState").getter(PostTextResponse.getter(PostTextResponse::dialogStateAsString)).setter(PostTextResponse.setter(Builder::dialogState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogState").build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotToElicit").getter(PostTextResponse.getter(PostTextResponse::slotToElicit)).setter(PostTextResponse.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotToElicit").build()}).build();
    private static final SdkField<ResponseCard> RESPONSE_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("responseCard").getter(PostTextResponse.getter(PostTextResponse::responseCard)).setter(PostTextResponse.setter(Builder::responseCard)).constructor(ResponseCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseCard").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(PostTextResponse.getter(PostTextResponse::sessionId)).setter(PostTextResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(PostTextResponse.getter(PostTextResponse::botVersion)).setter(PostTextResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeContexts").getter(PostTextResponse.getter(PostTextResponse::activeContexts)).setter(PostTextResponse.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, NLU_INTENT_CONFIDENCE_FIELD, ALTERNATIVE_INTENTS_FIELD, SLOTS_FIELD, SESSION_ATTRIBUTES_FIELD, MESSAGE_FIELD, SENTIMENT_RESPONSE_FIELD, MESSAGE_FORMAT_FIELD, DIALOG_STATE_FIELD, SLOT_TO_ELICIT_FIELD, RESPONSE_CARD_FIELD, SESSION_ID_FIELD, BOT_VERSION_FIELD, ACTIVE_CONTEXTS_FIELD));
    private final String intentName;
    private final IntentConfidence nluIntentConfidence;
    private final List<PredictedIntent> alternativeIntents;
    private final Map<String, String> slots;
    private final Map<String, String> sessionAttributes;
    private final String message;
    private final SentimentResponse sentimentResponse;
    private final String messageFormat;
    private final String dialogState;
    private final String slotToElicit;
    private final ResponseCard responseCard;
    private final String sessionId;
    private final String botVersion;
    private final List<ActiveContext> activeContexts;

    private PostTextResponse(BuilderImpl builder) {
        super(builder);
        this.intentName = builder.intentName;
        this.nluIntentConfidence = builder.nluIntentConfidence;
        this.alternativeIntents = builder.alternativeIntents;
        this.slots = builder.slots;
        this.sessionAttributes = builder.sessionAttributes;
        this.message = builder.message;
        this.sentimentResponse = builder.sentimentResponse;
        this.messageFormat = builder.messageFormat;
        this.dialogState = builder.dialogState;
        this.slotToElicit = builder.slotToElicit;
        this.responseCard = builder.responseCard;
        this.sessionId = builder.sessionId;
        this.botVersion = builder.botVersion;
        this.activeContexts = builder.activeContexts;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final IntentConfidence nluIntentConfidence() {
        return this.nluIntentConfidence;
    }

    public final boolean hasAlternativeIntents() {
        return this.alternativeIntents != null && !(this.alternativeIntents instanceof SdkAutoConstructList);
    }

    public final List<PredictedIntent> alternativeIntents() {
        return this.alternativeIntents;
    }

    public final boolean hasSlots() {
        return this.slots != null && !(this.slots instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> slots() {
        return this.slots;
    }

    public final boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public final String message() {
        return this.message;
    }

    public final SentimentResponse sentimentResponse() {
        return this.sentimentResponse;
    }

    public final MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(this.messageFormat);
    }

    public final String messageFormatAsString() {
        return this.messageFormat;
    }

    public final DialogState dialogState() {
        return DialogState.fromValue(this.dialogState);
    }

    public final String dialogStateAsString() {
        return this.dialogState;
    }

    public final String slotToElicit() {
        return this.slotToElicit;
    }

    public final ResponseCard responseCard() {
        return this.responseCard;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final boolean hasActiveContexts() {
        return this.activeContexts != null && !(this.activeContexts instanceof SdkAutoConstructList);
    }

    public final List<ActiveContext> activeContexts() {
        return this.activeContexts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nluIntentConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternativeIntents() ? this.alternativeIntents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlots() ? this.slots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionAttributes() ? this.sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCard());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveContexts() ? this.activeContexts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTextResponse)) {
            return false;
        }
        PostTextResponse other = (PostTextResponse)((Object)obj);
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.nluIntentConfidence(), other.nluIntentConfidence()) && this.hasAlternativeIntents() == other.hasAlternativeIntents() && Objects.equals(this.alternativeIntents(), other.alternativeIntents()) && this.hasSlots() == other.hasSlots() && Objects.equals(this.slots(), other.slots()) && this.hasSessionAttributes() == other.hasSessionAttributes() && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.sentimentResponse(), other.sentimentResponse()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.dialogStateAsString(), other.dialogStateAsString()) && Objects.equals(this.slotToElicit(), other.slotToElicit()) && Objects.equals(this.responseCard(), other.responseCard()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.botVersion(), other.botVersion()) && this.hasActiveContexts() == other.hasActiveContexts() && Objects.equals(this.activeContexts(), other.activeContexts());
    }

    public final String toString() {
        return ToString.builder((String)"PostTextResponse").add("IntentName", (Object)this.intentName()).add("NluIntentConfidence", (Object)this.nluIntentConfidence()).add("AlternativeIntents", this.hasAlternativeIntents() ? this.alternativeIntents() : null).add("Slots", (Object)(this.slots() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionAttributes", (Object)(this.sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("SentimentResponse", (Object)this.sentimentResponse()).add("MessageFormat", (Object)this.messageFormatAsString()).add("DialogState", (Object)this.dialogStateAsString()).add("SlotToElicit", (Object)this.slotToElicit()).add("ResponseCard", (Object)this.responseCard()).add("SessionId", (Object)this.sessionId()).add("BotVersion", (Object)this.botVersion()).add("ActiveContexts", (Object)(this.activeContexts() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "nluIntentConfidence": {
                return Optional.ofNullable(clazz.cast(this.nluIntentConfidence()));
            }
            case "alternativeIntents": {
                return Optional.ofNullable(clazz.cast(this.alternativeIntents()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "sentimentResponse": {
                return Optional.ofNullable(clazz.cast(this.sentimentResponse()));
            }
            case "messageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "dialogState": {
                return Optional.ofNullable(clazz.cast(this.dialogStateAsString()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
            case "responseCard": {
                return Optional.ofNullable(clazz.cast(this.responseCard()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostTextResponse, T> g) {
        return obj -> g.apply((PostTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeResponse.BuilderImpl
    implements Builder {
        private String intentName;
        private IntentConfidence nluIntentConfidence;
        private List<PredictedIntent> alternativeIntents = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> slots = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String message;
        private SentimentResponse sentimentResponse;
        private String messageFormat;
        private String dialogState;
        private String slotToElicit;
        private ResponseCard responseCard;
        private String sessionId;
        private String botVersion;
        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PostTextResponse model) {
            super(model);
            this.intentName(model.intentName);
            this.nluIntentConfidence(model.nluIntentConfidence);
            this.alternativeIntents(model.alternativeIntents);
            this.slots(model.slots);
            this.sessionAttributes(model.sessionAttributes);
            this.message(model.message);
            this.sentimentResponse(model.sentimentResponse);
            this.messageFormat(model.messageFormat);
            this.dialogState(model.dialogState);
            this.slotToElicit(model.slotToElicit);
            this.responseCard(model.responseCard);
            this.sessionId(model.sessionId);
            this.botVersion(model.botVersion);
            this.activeContexts(model.activeContexts);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final IntentConfidence.Builder getNluIntentConfidence() {
            return this.nluIntentConfidence != null ? this.nluIntentConfidence.toBuilder() : null;
        }

        @Override
        public final Builder nluIntentConfidence(IntentConfidence nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence;
            return this;
        }

        public final void setNluIntentConfidence(IntentConfidence.BuilderImpl nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence != null ? nluIntentConfidence.build() : null;
        }

        public final Collection<PredictedIntent.Builder> getAlternativeIntents() {
            if (this.alternativeIntents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alternativeIntents != null ? (Collection)this.alternativeIntents.stream().map(PredictedIntent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alternativeIntents(Collection<PredictedIntent> alternativeIntents) {
            this.alternativeIntents = IntentListCopier.copy(alternativeIntents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternativeIntents(PredictedIntent ... alternativeIntents) {
            this.alternativeIntents(Arrays.asList(alternativeIntents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternativeIntents(Consumer<PredictedIntent.Builder> ... alternativeIntents) {
            this.alternativeIntents(Stream.of(alternativeIntents).map(c -> (PredictedIntent)((PredictedIntent.Builder)PredictedIntent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlternativeIntents(Collection<PredictedIntent.BuilderImpl> alternativeIntents) {
            this.alternativeIntents = IntentListCopier.copyFromBuilder(alternativeIntents);
        }

        public final Map<String, String> getSlots() {
            if (this.slots instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.slots;
        }

        @Override
        public final Builder slots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
            return this;
        }

        public final void setSlots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
        }

        public final Map<String, String> getSessionAttributes() {
            if (this.sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final SentimentResponse.Builder getSentimentResponse() {
            return this.sentimentResponse != null ? this.sentimentResponse.toBuilder() : null;
        }

        @Override
        public final Builder sentimentResponse(SentimentResponse sentimentResponse) {
            this.sentimentResponse = sentimentResponse;
            return this;
        }

        public final void setSentimentResponse(SentimentResponse.BuilderImpl sentimentResponse) {
            this.sentimentResponse = sentimentResponse != null ? sentimentResponse.build() : null;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getDialogState() {
            return this.dialogState;
        }

        @Override
        public final Builder dialogState(String dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        public final Builder dialogState(DialogState dialogState) {
            this.dialogState(dialogState == null ? null : dialogState.toString());
            return this;
        }

        public final void setDialogState(String dialogState) {
            this.dialogState = dialogState;
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public final ResponseCard.Builder getResponseCard() {
            return this.responseCard != null ? this.responseCard.toBuilder() : null;
        }

        @Override
        public final Builder responseCard(ResponseCard responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(ResponseCard.BuilderImpl responseCard) {
            this.responseCard = responseCard != null ? responseCard.build() : null;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final Collection<ActiveContext.Builder> getActiveContexts() {
            if (this.activeContexts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.activeContexts != null ? (Collection)this.activeContexts.stream().map(ActiveContext::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(ActiveContext ... activeContexts) {
            this.activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder> ... activeContexts) {
            this.activeContexts(Stream.of(activeContexts).map(c -> (ActiveContext)((ActiveContext.Builder)ActiveContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        public PostTextResponse build() {
            return new PostTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostTextResponse> {
        public Builder intentName(String var1);

        public Builder nluIntentConfidence(IntentConfidence var1);

        default public Builder nluIntentConfidence(Consumer<IntentConfidence.Builder> nluIntentConfidence) {
            return this.nluIntentConfidence((IntentConfidence)((IntentConfidence.Builder)IntentConfidence.builder().applyMutation(nluIntentConfidence)).build());
        }

        public Builder alternativeIntents(Collection<PredictedIntent> var1);

        public Builder alternativeIntents(PredictedIntent ... var1);

        public Builder alternativeIntents(Consumer<PredictedIntent.Builder> ... var1);

        public Builder slots(Map<String, String> var1);

        public Builder sessionAttributes(Map<String, String> var1);

        public Builder message(String var1);

        public Builder sentimentResponse(SentimentResponse var1);

        default public Builder sentimentResponse(Consumer<SentimentResponse.Builder> sentimentResponse) {
            return this.sentimentResponse((SentimentResponse)((SentimentResponse.Builder)SentimentResponse.builder().applyMutation(sentimentResponse)).build());
        }

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatType var1);

        public Builder dialogState(String var1);

        public Builder dialogState(DialogState var1);

        public Builder slotToElicit(String var1);

        public Builder responseCard(ResponseCard var1);

        default public Builder responseCard(Consumer<ResponseCard.Builder> responseCard) {
            return this.responseCard((ResponseCard)((ResponseCard.Builder)ResponseCard.builder().applyMutation(responseCard)).build());
        }

        public Builder sessionId(String var1);

        public Builder botVersion(String var1);

        public Builder activeContexts(Collection<ActiveContext> var1);

        public Builder activeContexts(ActiveContext ... var1);

        public Builder activeContexts(Consumer<ActiveContext.Builder> ... var1);
    }
}

