/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.DialogAction;
import software.amazon.awssdk.services.lexruntime.model.IntentSummary;
import software.amazon.awssdk.services.lexruntime.model.IntentSummaryListCopier;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeResponse;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionResponse
extends LexRuntimeResponse
implements ToCopyableBuilder<Builder, GetSessionResponse> {
    private static final SdkField<List<IntentSummary>> RECENT_INTENT_SUMMARY_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recentIntentSummaryView").getter(GetSessionResponse.getter(GetSessionResponse::recentIntentSummaryView)).setter(GetSessionResponse.setter(Builder::recentIntentSummaryView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recentIntentSummaryView").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(GetSessionResponse.getter(GetSessionResponse::sessionAttributes)).setter(GetSessionResponse.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetSessionResponse.getter(GetSessionResponse::sessionId)).setter(GetSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialogAction").getter(GetSessionResponse.getter(GetSessionResponse::dialogAction)).setter(GetSessionResponse.setter(Builder::dialogAction)).constructor(DialogAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECENT_INTENT_SUMMARY_VIEW_FIELD, SESSION_ATTRIBUTES_FIELD, SESSION_ID_FIELD, DIALOG_ACTION_FIELD));
    private final List<IntentSummary> recentIntentSummaryView;
    private final Map<String, String> sessionAttributes;
    private final String sessionId;
    private final DialogAction dialogAction;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.recentIntentSummaryView = builder.recentIntentSummaryView;
        this.sessionAttributes = builder.sessionAttributes;
        this.sessionId = builder.sessionId;
        this.dialogAction = builder.dialogAction;
    }

    public boolean hasRecentIntentSummaryView() {
        return this.recentIntentSummaryView != null && !(this.recentIntentSummaryView instanceof SdkAutoConstructList);
    }

    public List<IntentSummary> recentIntentSummaryView() {
        return this.recentIntentSummaryView;
    }

    public boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public DialogAction dialogAction() {
        return this.dialogAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recentIntentSummaryView());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse)((Object)obj);
        return Objects.equals(this.recentIntentSummaryView(), other.recentIntentSummaryView()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.dialogAction(), other.dialogAction());
    }

    public String toString() {
        return ToString.builder((String)"GetSessionResponse").add("RecentIntentSummaryView", this.recentIntentSummaryView()).add("SessionAttributes", (Object)(this.sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionId", (Object)this.sessionId()).add("DialogAction", (Object)this.dialogAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recentIntentSummaryView": {
                return Optional.ofNullable(clazz.cast(this.recentIntentSummaryView()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "dialogAction": {
                return Optional.ofNullable(clazz.cast(this.dialogAction()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeResponse.BuilderImpl
    implements Builder {
        private List<IntentSummary> recentIntentSummaryView = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String sessionId;
        private DialogAction dialogAction;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            this.recentIntentSummaryView(model.recentIntentSummaryView);
            this.sessionAttributes(model.sessionAttributes);
            this.sessionId(model.sessionId);
            this.dialogAction(model.dialogAction);
        }

        public final Collection<IntentSummary.Builder> getRecentIntentSummaryView() {
            return this.recentIntentSummaryView != null ? (Collection)this.recentIntentSummaryView.stream().map(IntentSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copy(recentIntentSummaryView);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentIntentSummaryView(IntentSummary ... recentIntentSummaryView) {
            this.recentIntentSummaryView(Arrays.asList(recentIntentSummaryView));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentIntentSummaryView(Consumer<IntentSummary.Builder> ... recentIntentSummaryView) {
            this.recentIntentSummaryView(Stream.of(recentIntentSummaryView).map(c -> (IntentSummary)((IntentSummary.Builder)IntentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecentIntentSummaryView(Collection<IntentSummary.BuilderImpl> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copyFromBuilder(recentIntentSummaryView);
        }

        public final Map<String, String> getSessionAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final DialogAction.Builder getDialogAction() {
            return this.dialogAction != null ? this.dialogAction.toBuilder() : null;
        }

        @Override
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionResponse> {
        public Builder recentIntentSummaryView(Collection<IntentSummary> var1);

        public Builder recentIntentSummaryView(IntentSummary ... var1);

        public Builder recentIntentSummaryView(Consumer<IntentSummary.Builder> ... var1);

        public Builder sessionAttributes(Map<String, String> var1);

        public Builder sessionId(String var1);

        public Builder dialogAction(DialogAction var1);

        default public Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return this.dialogAction((DialogAction)((DialogAction.Builder)DialogAction.builder().applyMutation(dialogAction)).build());
        }
    }
}

