/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeClientBuilder;
import software.amazon.awssdk.services.lexruntime.model.BadGatewayException;
import software.amazon.awssdk.services.lexruntime.model.BadRequestException;
import software.amazon.awssdk.services.lexruntime.model.ConflictException;
import software.amazon.awssdk.services.lexruntime.model.DependencyFailedException;
import software.amazon.awssdk.services.lexruntime.model.InternalFailureException;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeException;
import software.amazon.awssdk.services.lexruntime.model.LimitExceededException;
import software.amazon.awssdk.services.lexruntime.model.LoopDetectedException;
import software.amazon.awssdk.services.lexruntime.model.NotAcceptableException;
import software.amazon.awssdk.services.lexruntime.model.NotFoundException;
import software.amazon.awssdk.services.lexruntime.model.PostContentRequest;
import software.amazon.awssdk.services.lexruntime.model.PostContentResponse;
import software.amazon.awssdk.services.lexruntime.model.PostTextRequest;
import software.amazon.awssdk.services.lexruntime.model.PostTextResponse;
import software.amazon.awssdk.services.lexruntime.model.RequestTimeoutException;
import software.amazon.awssdk.services.lexruntime.model.UnsupportedMediaTypeException;

public interface LexRuntimeClient
extends SdkClient {
    public static final String SERVICE_NAME = "lex";

    public static LexRuntimeClient create() {
        return (LexRuntimeClient)LexRuntimeClient.builder().build();
    }

    public static LexRuntimeClientBuilder builder() {
        return new DefaultLexRuntimeClientBuilder();
    }

    default public <ReturnT> ReturnT postContent(PostContentRequest postContentRequest, RequestBody requestBody, ResponseTransformer<PostContentResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT postContent(Consumer<PostContentRequest.Builder> postContentRequest, RequestBody requestBody, ResponseTransformer<PostContentResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), requestBody, responseTransformer);
    }

    default public PostContentResponse postContent(PostContentRequest postContentRequest, Path sourcePath, Path destinationPath) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return (PostContentResponse)((Object)this.postContent(postContentRequest, RequestBody.fromFile((Path)sourcePath), ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public PostContentResponse postContent(Consumer<PostContentRequest.Builder> postContentRequest, Path sourcePath, Path destinationPath) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), sourcePath, destinationPath);
    }

    default public PostTextResponse postText(PostTextRequest postTextRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        throw new UnsupportedOperationException();
    }

    default public PostTextResponse postText(Consumer<PostTextRequest.Builder> postTextRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.postText((PostTextRequest)((Object)((PostTextRequest.Builder)PostTextRequest.builder().applyMutation(postTextRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"runtime.lex");
    }
}

