/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.DialogState;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeResponse;
import software.amazon.awssdk.services.lexruntime.model.MessageFormatType;
import software.amazon.awssdk.services.lexruntime.model.ResponseCard;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostTextResponse
extends LexRuntimeResponse
implements ToCopyableBuilder<Builder, PostTextResponse> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostTextResponse.getter(PostTextResponse::intentName)).setter(PostTextResponse.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<Map<String, String>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(PostTextResponse.getter(PostTextResponse::slots)).setter(PostTextResponse.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(PostTextResponse.getter(PostTextResponse::sessionAttributes)).setter(PostTextResponse.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostTextResponse.getter(PostTextResponse::message)).setter(PostTextResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostTextResponse.getter(PostTextResponse::messageFormatAsString)).setter(PostTextResponse.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageFormat").build()}).build();
    private static final SdkField<String> DIALOG_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostTextResponse.getter(PostTextResponse::dialogStateAsString)).setter(PostTextResponse.setter(Builder::dialogState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogState").build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostTextResponse.getter(PostTextResponse::slotToElicit)).setter(PostTextResponse.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotToElicit").build()}).build();
    private static final SdkField<ResponseCard> RESPONSE_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PostTextResponse.getter(PostTextResponse::responseCard)).setter(PostTextResponse.setter(Builder::responseCard)).constructor(ResponseCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseCard").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, SLOTS_FIELD, SESSION_ATTRIBUTES_FIELD, MESSAGE_FIELD, MESSAGE_FORMAT_FIELD, DIALOG_STATE_FIELD, SLOT_TO_ELICIT_FIELD, RESPONSE_CARD_FIELD));
    private final String intentName;
    private final Map<String, String> slots;
    private final Map<String, String> sessionAttributes;
    private final String message;
    private final String messageFormat;
    private final String dialogState;
    private final String slotToElicit;
    private final ResponseCard responseCard;

    private PostTextResponse(BuilderImpl builder) {
        super(builder);
        this.intentName = builder.intentName;
        this.slots = builder.slots;
        this.sessionAttributes = builder.sessionAttributes;
        this.message = builder.message;
        this.messageFormat = builder.messageFormat;
        this.dialogState = builder.dialogState;
        this.slotToElicit = builder.slotToElicit;
        this.responseCard = builder.responseCard;
    }

    public String intentName() {
        return this.intentName;
    }

    public Map<String, String> slots() {
        return this.slots;
    }

    public Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public String message() {
        return this.message;
    }

    public MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(this.messageFormat);
    }

    public String messageFormatAsString() {
        return this.messageFormat;
    }

    public DialogState dialogState() {
        return DialogState.fromValue(this.dialogState);
    }

    public String dialogStateAsString() {
        return this.dialogState;
    }

    public String slotToElicit() {
        return this.slotToElicit;
    }

    public ResponseCard responseCard() {
        return this.responseCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCard());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTextResponse)) {
            return false;
        }
        PostTextResponse other = (PostTextResponse)((Object)obj);
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.dialogStateAsString(), other.dialogStateAsString()) && Objects.equals(this.slotToElicit(), other.slotToElicit()) && Objects.equals(this.responseCard(), other.responseCard());
    }

    public String toString() {
        return ToString.builder((String)"PostTextResponse").add("IntentName", (Object)this.intentName()).add("Slots", this.slots()).add("SessionAttributes", this.sessionAttributes()).add("Message", (Object)this.message()).add("MessageFormat", (Object)this.messageFormatAsString()).add("DialogState", (Object)this.dialogStateAsString()).add("SlotToElicit", (Object)this.slotToElicit()).add("ResponseCard", (Object)this.responseCard()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "messageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "dialogState": {
                return Optional.ofNullable(clazz.cast(this.dialogStateAsString()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
            case "responseCard": {
                return Optional.ofNullable(clazz.cast(this.responseCard()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostTextResponse, T> g) {
        return obj -> g.apply((PostTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeResponse.BuilderImpl
    implements Builder {
        private String intentName;
        private Map<String, String> slots = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String message;
        private String messageFormat;
        private String dialogState;
        private String slotToElicit;
        private ResponseCard responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(PostTextResponse model) {
            super(model);
            this.intentName(model.intentName);
            this.slots(model.slots);
            this.sessionAttributes(model.sessionAttributes);
            this.message(model.message);
            this.messageFormat(model.messageFormat);
            this.dialogState(model.dialogState);
            this.slotToElicit(model.slotToElicit);
            this.responseCard(model.responseCard);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final Map<String, String> getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
            return this;
        }

        public final void setSlots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
        }

        public final Map<String, String> getSessionAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getDialogState() {
            return this.dialogState;
        }

        @Override
        public final Builder dialogState(String dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        public final Builder dialogState(DialogState dialogState) {
            this.dialogState(dialogState.toString());
            return this;
        }

        public final void setDialogState(String dialogState) {
            this.dialogState = dialogState;
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public final ResponseCard.Builder getResponseCard() {
            return this.responseCard != null ? this.responseCard.toBuilder() : null;
        }

        @Override
        public final Builder responseCard(ResponseCard responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(ResponseCard.BuilderImpl responseCard) {
            this.responseCard = responseCard != null ? responseCard.build() : null;
        }

        @Override
        public PostTextResponse build() {
            return new PostTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostTextResponse> {
        public Builder intentName(String var1);

        public Builder slots(Map<String, String> var1);

        public Builder sessionAttributes(Map<String, String> var1);

        public Builder message(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatType var1);

        public Builder dialogState(String var1);

        public Builder dialogState(DialogState var1);

        public Builder slotToElicit(String var1);

        public Builder responseCard(ResponseCard var1);

        default public Builder responseCard(Consumer<ResponseCard.Builder> responseCard) {
            return this.responseCard((ResponseCard)((ResponseCard.Builder)ResponseCard.builder().applyMutation(responseCard)).build());
        }
    }
}

