/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.lexruntime.model.PostContentRequest;
import software.amazon.awssdk.services.lexruntime.model.PostContentResponse;
import software.amazon.awssdk.services.lexruntime.model.PostTextRequest;
import software.amazon.awssdk.services.lexruntime.model.PostTextResponse;

public interface LexRuntimeAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "lex";

    public static LexRuntimeAsyncClient create() {
        return (LexRuntimeAsyncClient)LexRuntimeAsyncClient.builder().build();
    }

    public static LexRuntimeAsyncClientBuilder builder() {
        return new DefaultLexRuntimeAsyncClientBuilder();
    }

    default public <ReturnT> CompletableFuture<ReturnT> postContent(PostContentRequest postContentRequest, AsyncRequestBody requestBody, AsyncResponseTransformer<PostContentResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> postContent(Consumer<PostContentRequest.Builder> postContentRequest, AsyncRequestBody requestBody, AsyncResponseTransformer<PostContentResponse, ReturnT> asyncResponseTransformer) {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), requestBody, asyncResponseTransformer);
    }

    default public CompletableFuture<PostContentResponse> postContent(PostContentRequest postContentRequest, Path sourcePath, Path destinationPath) {
        return this.postContent(postContentRequest, AsyncRequestBody.fromFile((Path)sourcePath), AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<PostContentResponse> postContent(Consumer<PostContentRequest.Builder> postContentRequest, Path sourcePath, Path destinationPath) {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), sourcePath, destinationPath);
    }

    default public CompletableFuture<PostTextResponse> postText(PostTextRequest postTextRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PostTextResponse> postText(Consumer<PostTextRequest.Builder> postTextRequest) {
        return this.postText((PostTextRequest)((Object)((PostTextRequest.Builder)PostTextRequest.builder().applyMutation(postTextRequest)).build()));
    }
}

