/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexruntime.model.Button;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ButtonMarshaller {
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("text").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final ButtonMarshaller INSTANCE = new ButtonMarshaller();

    private ButtonMarshaller() {
    }

    public static ButtonMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Button button, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)button, (String)"button");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)button.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)button.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

