/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput;
import software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutputMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserTurnIntentOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserTurnIntentOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UserTurnIntentOutput.getter(UserTurnIntentOutput::name)).setter(UserTurnIntentOutput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, UserTurnSlotOutput>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("slots").getter(UserTurnIntentOutput.getter(UserTurnIntentOutput::slots)).setter(UserTurnIntentOutput.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserTurnSlotOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SLOTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("slots", SLOTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, UserTurnSlotOutput> slots;

    private UserTurnIntentOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.slots = builder.slots;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSlots() {
        return this.slots != null && !(this.slots instanceof SdkAutoConstructMap);
    }

    public final Map<String, UserTurnSlotOutput> slots() {
        return this.slots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlots() ? this.slots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnIntentOutput)) {
            return false;
        }
        UserTurnIntentOutput other = (UserTurnIntentOutput)obj;
        return Objects.equals(this.name(), other.name()) && this.hasSlots() == other.hasSlots() && Objects.equals(this.slots(), other.slots());
    }

    public final String toString() {
        return ToString.builder((String)"UserTurnIntentOutput").add("Name", (Object)this.name()).add("Slots", this.hasSlots() ? this.slots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UserTurnIntentOutput, T> g) {
        return obj -> g.apply((UserTurnIntentOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Map<String, UserTurnSlotOutput> slots = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnIntentOutput model) {
            this.name(model.name);
            this.slots(model.slots);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, UserTurnSlotOutput.Builder> getSlots() {
            Map<String, UserTurnSlotOutput.Builder> result = UserTurnSlotOutputMapCopier.copyToBuilder(this.slots);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSlots(Map<String, UserTurnSlotOutput.BuilderImpl> slots) {
            this.slots = UserTurnSlotOutputMapCopier.copyFromBuilder(slots);
        }

        @Override
        public final Builder slots(Map<String, UserTurnSlotOutput> slots) {
            this.slots = UserTurnSlotOutputMapCopier.copy(slots);
            return this;
        }

        public UserTurnIntentOutput build() {
            return new UserTurnIntentOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserTurnIntentOutput> {
        public Builder name(String var1);

        public Builder slots(Map<String, UserTurnSlotOutput> var1);
    }
}

