/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BedrockModelSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.DataSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QnAIntentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QnAIntentConfiguration> {
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSourceConfiguration").getter(QnAIntentConfiguration.getter(QnAIntentConfiguration::dataSourceConfiguration)).setter(QnAIntentConfiguration.setter(Builder::dataSourceConfiguration)).constructor(DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfiguration").build()}).build();
    private static final SdkField<BedrockModelSpecification> BEDROCK_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bedrockModelConfiguration").getter(QnAIntentConfiguration.getter(QnAIntentConfiguration::bedrockModelConfiguration)).setter(QnAIntentConfiguration.setter(Builder::bedrockModelConfiguration)).constructor(BedrockModelSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_CONFIGURATION_FIELD, BEDROCK_MODEL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
            this.put("bedrockModelConfiguration", BEDROCK_MODEL_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final BedrockModelSpecification bedrockModelConfiguration;

    private QnAIntentConfiguration(BuilderImpl builder) {
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.bedrockModelConfiguration = builder.bedrockModelConfiguration;
    }

    public final DataSourceConfiguration dataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    public final BedrockModelSpecification bedrockModelConfiguration() {
        return this.bedrockModelConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bedrockModelConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QnAIntentConfiguration)) {
            return false;
        }
        QnAIntentConfiguration other = (QnAIntentConfiguration)obj;
        return Objects.equals(this.dataSourceConfiguration(), other.dataSourceConfiguration()) && Objects.equals(this.bedrockModelConfiguration(), other.bedrockModelConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"QnAIntentConfiguration").add("DataSourceConfiguration", (Object)this.dataSourceConfiguration()).add("BedrockModelConfiguration", (Object)this.bedrockModelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfiguration()));
            }
            case "bedrockModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bedrockModelConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QnAIntentConfiguration, T> g) {
        return obj -> g.apply((QnAIntentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataSourceConfiguration dataSourceConfiguration;
        private BedrockModelSpecification bedrockModelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QnAIntentConfiguration model) {
            this.dataSourceConfiguration(model.dataSourceConfiguration);
            this.bedrockModelConfiguration(model.bedrockModelConfiguration);
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return this.dataSourceConfiguration != null ? this.dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final BedrockModelSpecification.Builder getBedrockModelConfiguration() {
            return this.bedrockModelConfiguration != null ? this.bedrockModelConfiguration.toBuilder() : null;
        }

        public final void setBedrockModelConfiguration(BedrockModelSpecification.BuilderImpl bedrockModelConfiguration) {
            this.bedrockModelConfiguration = bedrockModelConfiguration != null ? bedrockModelConfiguration.build() : null;
        }

        @Override
        public final Builder bedrockModelConfiguration(BedrockModelSpecification bedrockModelConfiguration) {
            this.bedrockModelConfiguration = bedrockModelConfiguration;
            return this;
        }

        public QnAIntentConfiguration build() {
            return new QnAIntentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QnAIntentConfiguration> {
        public Builder dataSourceConfiguration(DataSourceConfiguration var1);

        default public Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return this.dataSourceConfiguration((DataSourceConfiguration)((DataSourceConfiguration.Builder)DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration)).build());
        }

        public Builder bedrockModelConfiguration(BedrockModelSpecification var1);

        default public Builder bedrockModelConfiguration(Consumer<BedrockModelSpecification.Builder> bedrockModelConfiguration) {
            return this.bedrockModelConfiguration((BedrockModelSpecification)((BedrockModelSpecification.Builder)BedrockModelSpecification.builder().applyMutation(bedrockModelConfiguration)).build());
        }
    }
}

