/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch;
import software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranchesCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.DefaultConditionalBranch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionalSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionalSpecification> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(ConditionalSpecification.getter(ConditionalSpecification::active)).setter(ConditionalSpecification.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final SdkField<List<ConditionalBranch>> CONDITIONAL_BRANCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditionalBranches").getter(ConditionalSpecification.getter(ConditionalSpecification::conditionalBranches)).setter(ConditionalSpecification.setter(Builder::conditionalBranches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionalBranches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConditionalBranch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DefaultConditionalBranch> DEFAULT_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultBranch").getter(ConditionalSpecification.getter(ConditionalSpecification::defaultBranch)).setter(ConditionalSpecification.setter(Builder::defaultBranch)).constructor(DefaultConditionalBranch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBranch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD, CONDITIONAL_BRANCHES_FIELD, DEFAULT_BRANCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("active", ACTIVE_FIELD);
            this.put("conditionalBranches", CONDITIONAL_BRANCHES_FIELD);
            this.put("defaultBranch", DEFAULT_BRANCH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean active;
    private final List<ConditionalBranch> conditionalBranches;
    private final DefaultConditionalBranch defaultBranch;

    private ConditionalSpecification(BuilderImpl builder) {
        this.active = builder.active;
        this.conditionalBranches = builder.conditionalBranches;
        this.defaultBranch = builder.defaultBranch;
    }

    public final Boolean active() {
        return this.active;
    }

    public final boolean hasConditionalBranches() {
        return this.conditionalBranches != null && !(this.conditionalBranches instanceof SdkAutoConstructList);
    }

    public final List<ConditionalBranch> conditionalBranches() {
        return this.conditionalBranches;
    }

    public final DefaultConditionalBranch defaultBranch() {
        return this.defaultBranch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditionalBranches() ? this.conditionalBranches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBranch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalSpecification)) {
            return false;
        }
        ConditionalSpecification other = (ConditionalSpecification)obj;
        return Objects.equals(this.active(), other.active()) && this.hasConditionalBranches() == other.hasConditionalBranches() && Objects.equals(this.conditionalBranches(), other.conditionalBranches()) && Objects.equals(this.defaultBranch(), other.defaultBranch());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionalSpecification").add("Active", (Object)this.active()).add("ConditionalBranches", this.hasConditionalBranches() ? this.conditionalBranches() : null).add("DefaultBranch", (Object)this.defaultBranch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "conditionalBranches": {
                return Optional.ofNullable(clazz.cast(this.conditionalBranches()));
            }
            case "defaultBranch": {
                return Optional.ofNullable(clazz.cast(this.defaultBranch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConditionalSpecification, T> g) {
        return obj -> g.apply((ConditionalSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean active;
        private List<ConditionalBranch> conditionalBranches = DefaultSdkAutoConstructList.getInstance();
        private DefaultConditionalBranch defaultBranch;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalSpecification model) {
            this.active(model.active);
            this.conditionalBranches(model.conditionalBranches);
            this.defaultBranch(model.defaultBranch);
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final List<ConditionalBranch.Builder> getConditionalBranches() {
            List<ConditionalBranch.Builder> result = ConditionalBranchesCopier.copyToBuilder(this.conditionalBranches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionalBranches(Collection<ConditionalBranch.BuilderImpl> conditionalBranches) {
            this.conditionalBranches = ConditionalBranchesCopier.copyFromBuilder(conditionalBranches);
        }

        @Override
        public final Builder conditionalBranches(Collection<ConditionalBranch> conditionalBranches) {
            this.conditionalBranches = ConditionalBranchesCopier.copy(conditionalBranches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalBranches(ConditionalBranch ... conditionalBranches) {
            this.conditionalBranches(Arrays.asList(conditionalBranches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalBranches(Consumer<ConditionalBranch.Builder> ... conditionalBranches) {
            this.conditionalBranches(Stream.of(conditionalBranches).map(c -> (ConditionalBranch)((ConditionalBranch.Builder)ConditionalBranch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DefaultConditionalBranch.Builder getDefaultBranch() {
            return this.defaultBranch != null ? this.defaultBranch.toBuilder() : null;
        }

        public final void setDefaultBranch(DefaultConditionalBranch.BuilderImpl defaultBranch) {
            this.defaultBranch = defaultBranch != null ? defaultBranch.build() : null;
        }

        @Override
        public final Builder defaultBranch(DefaultConditionalBranch defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        public ConditionalSpecification build() {
            return new ConditionalSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionalSpecification> {
        public Builder active(Boolean var1);

        public Builder conditionalBranches(Collection<ConditionalBranch> var1);

        public Builder conditionalBranches(ConditionalBranch ... var1);

        public Builder conditionalBranches(Consumer<ConditionalBranch.Builder> ... var1);

        public Builder defaultBranch(DefaultConditionalBranch var1);

        default public Builder defaultBranch(Consumer<DefaultConditionalBranch.Builder> defaultBranch) {
            return this.defaultBranch((DefaultConditionalBranch)((DefaultConditionalBranch.Builder)DefaultConditionalBranch.builder().applyMutation(defaultBranch)).build());
        }
    }
}

