/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotVersionSummary> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(BotVersionSummary.getter(BotVersionSummary::botName)).setter(BotVersionSummary.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(BotVersionSummary.getter(BotVersionSummary::botVersion)).setter(BotVersionSummary.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(BotVersionSummary.getter(BotVersionSummary::description)).setter(BotVersionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botStatus").getter(BotVersionSummary.getter(BotVersionSummary::botStatusAsString)).setter(BotVersionSummary.setter(Builder::botStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(BotVersionSummary.getter(BotVersionSummary::creationDateTime)).setter(BotVersionSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, BOT_VERSION_FIELD, DESCRIPTION_FIELD, BOT_STATUS_FIELD, CREATION_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botName", BOT_NAME_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("botStatus", BOT_STATUS_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String botName;
    private final String botVersion;
    private final String description;
    private final String botStatus;
    private final Instant creationDateTime;

    private BotVersionSummary(BuilderImpl builder) {
        this.botName = builder.botName;
        this.botVersion = builder.botVersion;
        this.description = builder.description;
        this.botStatus = builder.botStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    public final String botName() {
        return this.botName;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String description() {
        return this.description;
    }

    public final BotStatus botStatus() {
        return BotStatus.fromValue(this.botStatus);
    }

    public final String botStatusAsString() {
        return this.botStatus;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotVersionSummary)) {
            return false;
        }
        BotVersionSummary other = (BotVersionSummary)obj;
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.botStatusAsString(), other.botStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"BotVersionSummary").add("BotName", (Object)this.botName()).add("BotVersion", (Object)this.botVersion()).add("Description", (Object)this.description()).add("BotStatus", (Object)this.botStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "botStatus": {
                return Optional.ofNullable(clazz.cast(this.botStatusAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BotVersionSummary, T> g) {
        return obj -> g.apply((BotVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botName;
        private String botVersion;
        private String description;
        private String botStatus;
        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BotVersionSummary model) {
            this.botName(model.botName);
            this.botVersion(model.botVersion);
            this.description(model.description);
            this.botStatus(model.botStatus);
            this.creationDateTime(model.creationDateTime);
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotStatus() {
            return this.botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public BotVersionSummary build() {
            return new BotVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotVersionSummary> {
        public Builder botName(String var1);

        public Builder botVersion(String var1);

        public Builder description(String var1);

        public Builder botStatus(String var1);

        public Builder botStatus(BotStatus var1);

        public Builder creationDateTime(Instant var1);
    }
}

