/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdatesSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FulfillmentCodeHookSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FulfillmentCodeHookSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(FulfillmentCodeHookSettings.getter(FulfillmentCodeHookSettings::enabled)).setter(FulfillmentCodeHookSettings.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<PostFulfillmentStatusSpecification> POST_FULFILLMENT_STATUS_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postFulfillmentStatusSpecification").getter(FulfillmentCodeHookSettings.getter(FulfillmentCodeHookSettings::postFulfillmentStatusSpecification)).setter(FulfillmentCodeHookSettings.setter(Builder::postFulfillmentStatusSpecification)).constructor(PostFulfillmentStatusSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postFulfillmentStatusSpecification").build()}).build();
    private static final SdkField<FulfillmentUpdatesSpecification> FULFILLMENT_UPDATES_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fulfillmentUpdatesSpecification").getter(FulfillmentCodeHookSettings.getter(FulfillmentCodeHookSettings::fulfillmentUpdatesSpecification)).setter(FulfillmentCodeHookSettings.setter(Builder::fulfillmentUpdatesSpecification)).constructor(FulfillmentUpdatesSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentUpdatesSpecification").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(FulfillmentCodeHookSettings.getter(FulfillmentCodeHookSettings::active)).setter(FulfillmentCodeHookSettings.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, POST_FULFILLMENT_STATUS_SPECIFICATION_FIELD, FULFILLMENT_UPDATES_SPECIFICATION_FIELD, ACTIVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final PostFulfillmentStatusSpecification postFulfillmentStatusSpecification;
    private final FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification;
    private final Boolean active;

    private FulfillmentCodeHookSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.postFulfillmentStatusSpecification = builder.postFulfillmentStatusSpecification;
        this.fulfillmentUpdatesSpecification = builder.fulfillmentUpdatesSpecification;
        this.active = builder.active;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final PostFulfillmentStatusSpecification postFulfillmentStatusSpecification() {
        return this.postFulfillmentStatusSpecification;
    }

    public final FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification() {
        return this.fulfillmentUpdatesSpecification;
    }

    public final Boolean active() {
        return this.active;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.postFulfillmentStatusSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentUpdatesSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentCodeHookSettings)) {
            return false;
        }
        FulfillmentCodeHookSettings other = (FulfillmentCodeHookSettings)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.postFulfillmentStatusSpecification(), other.postFulfillmentStatusSpecification()) && Objects.equals(this.fulfillmentUpdatesSpecification(), other.fulfillmentUpdatesSpecification()) && Objects.equals(this.active(), other.active());
    }

    public final String toString() {
        return ToString.builder((String)"FulfillmentCodeHookSettings").add("Enabled", (Object)this.enabled()).add("PostFulfillmentStatusSpecification", (Object)this.postFulfillmentStatusSpecification()).add("FulfillmentUpdatesSpecification", (Object)this.fulfillmentUpdatesSpecification()).add("Active", (Object)this.active()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "postFulfillmentStatusSpecification": {
                return Optional.ofNullable(clazz.cast(this.postFulfillmentStatusSpecification()));
            }
            case "fulfillmentUpdatesSpecification": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentUpdatesSpecification()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentCodeHookSettings, T> g) {
        return obj -> g.apply((FulfillmentCodeHookSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private PostFulfillmentStatusSpecification postFulfillmentStatusSpecification;
        private FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification;
        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentCodeHookSettings model) {
            this.enabled(model.enabled);
            this.postFulfillmentStatusSpecification(model.postFulfillmentStatusSpecification);
            this.fulfillmentUpdatesSpecification(model.fulfillmentUpdatesSpecification);
            this.active(model.active);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final PostFulfillmentStatusSpecification.Builder getPostFulfillmentStatusSpecification() {
            return this.postFulfillmentStatusSpecification != null ? this.postFulfillmentStatusSpecification.toBuilder() : null;
        }

        public final void setPostFulfillmentStatusSpecification(PostFulfillmentStatusSpecification.BuilderImpl postFulfillmentStatusSpecification) {
            this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification != null ? postFulfillmentStatusSpecification.build() : null;
        }

        @Override
        public final Builder postFulfillmentStatusSpecification(PostFulfillmentStatusSpecification postFulfillmentStatusSpecification) {
            this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
            return this;
        }

        public final FulfillmentUpdatesSpecification.Builder getFulfillmentUpdatesSpecification() {
            return this.fulfillmentUpdatesSpecification != null ? this.fulfillmentUpdatesSpecification.toBuilder() : null;
        }

        public final void setFulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification.BuilderImpl fulfillmentUpdatesSpecification) {
            this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification != null ? fulfillmentUpdatesSpecification.build() : null;
        }

        @Override
        public final Builder fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification) {
            this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public FulfillmentCodeHookSettings build() {
            return new FulfillmentCodeHookSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FulfillmentCodeHookSettings> {
        public Builder enabled(Boolean var1);

        public Builder postFulfillmentStatusSpecification(PostFulfillmentStatusSpecification var1);

        default public Builder postFulfillmentStatusSpecification(Consumer<PostFulfillmentStatusSpecification.Builder> postFulfillmentStatusSpecification) {
            return this.postFulfillmentStatusSpecification((PostFulfillmentStatusSpecification)((PostFulfillmentStatusSpecification.Builder)PostFulfillmentStatusSpecification.builder().applyMutation(postFulfillmentStatusSpecification)).build());
        }

        public Builder fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification var1);

        default public Builder fulfillmentUpdatesSpecification(Consumer<FulfillmentUpdatesSpecification.Builder> fulfillmentUpdatesSpecification) {
            return this.fulfillmentUpdatesSpecification((FulfillmentUpdatesSpecification)((FulfillmentUpdatesSpecification.Builder)FulfillmentUpdatesSpecification.builder().applyMutation(fulfillmentUpdatesSpecification)).build());
        }

        public Builder active(Boolean var1);
    }
}

