/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSlotsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListSlotsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListSlotsResponse.getter(ListSlotsResponse::botId)).setter(ListSlotsResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListSlotsResponse.getter(ListSlotsResponse::botVersion)).setter(ListSlotsResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListSlotsResponse.getter(ListSlotsResponse::localeId)).setter(ListSlotsResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentId").getter(ListSlotsResponse.getter(ListSlotsResponse::intentId)).setter(ListSlotsResponse.setter(Builder::intentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()}).build();
    private static final SdkField<List<SlotSummary>> SLOT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slotSummaries").getter(ListSlotsResponse.getter(ListSlotsResponse::slotSummaries)).setter(ListSlotsResponse.setter(Builder::slotSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSlotsResponse.getter(ListSlotsResponse::nextToken)).setter(ListSlotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, INTENT_ID_FIELD, SLOT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String intentId;
    private final List<SlotSummary> slotSummaries;
    private final String nextToken;

    private ListSlotsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.intentId = builder.intentId;
        this.slotSummaries = builder.slotSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String intentId() {
        return this.intentId;
    }

    public final boolean hasSlotSummaries() {
        return this.slotSummaries != null && !(this.slotSummaries instanceof SdkAutoConstructList);
    }

    public final List<SlotSummary> slotSummaries() {
        return this.slotSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotSummaries() ? this.slotSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlotsResponse)) {
            return false;
        }
        ListSlotsResponse other = (ListSlotsResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.intentId(), other.intentId()) && this.hasSlotSummaries() == other.hasSlotSummaries() && Objects.equals(this.slotSummaries(), other.slotSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSlotsResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("IntentId", (Object)this.intentId()).add("SlotSummaries", this.hasSlotSummaries() ? this.slotSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "intentId": {
                return Optional.ofNullable(clazz.cast(this.intentId()));
            }
            case "slotSummaries": {
                return Optional.ofNullable(clazz.cast(this.slotSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSlotsResponse, T> g) {
        return obj -> g.apply((ListSlotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String intentId;
        private List<SlotSummary> slotSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlotsResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.intentId(model.intentId);
            this.slotSummaries(model.slotSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final String getIntentId() {
            return this.intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        public final Collection<SlotSummary.Builder> getSlotSummaries() {
            if (this.slotSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.slotSummaries != null ? (Collection)this.slotSummaries.stream().map(SlotSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slotSummaries(Collection<SlotSummary> slotSummaries) {
            this.slotSummaries = SlotSummaryListCopier.copy(slotSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotSummaries(SlotSummary ... slotSummaries) {
            this.slotSummaries(Arrays.asList(slotSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotSummaries(Consumer<SlotSummary.Builder> ... slotSummaries) {
            this.slotSummaries(Stream.of(slotSummaries).map(c -> (SlotSummary)((SlotSummary.Builder)SlotSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlotSummaries(Collection<SlotSummary.BuilderImpl> slotSummaries) {
            this.slotSummaries = SlotSummaryListCopier.copyFromBuilder(slotSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSlotsResponse build() {
            return new ListSlotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSlotsResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder intentId(String var1);

        public Builder slotSummaries(Collection<SlotSummary> var1);

        public Builder slotSummaries(SlotSummary ... var1);

        public Builder slotSummaries(Consumer<SlotSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

