/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBotLocaleRequest extends LexModelsV2Request implements
        ToCopyableBuilder<UpdateBotLocaleRequest.Builder, UpdateBotLocaleRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateBotLocaleRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(UpdateBotLocaleRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(UpdateBotLocaleRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateBotLocaleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("nluIntentConfidenceThreshold")
            .getter(getter(UpdateBotLocaleRequest::nluIntentConfidenceThreshold))
            .setter(setter(Builder::nluIntentConfidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold")
                    .build()).build();

    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField
            .<VoiceSettings> builder(MarshallingType.SDK_POJO).memberName("voiceSettings")
            .getter(getter(UpdateBotLocaleRequest::voiceSettings)).setter(setter(Builder::voiceSettings))
            .constructor(VoiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, DESCRIPTION_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, VOICE_SETTINGS_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String description;

    private final Double nluIntentConfidenceThreshold;

    private final VoiceSettings voiceSettings;

    private UpdateBotLocaleRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.description = builder.description;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
    }

    /**
     * <p>
     * The unique identifier of the bot that contains the locale.
     * </p>
     * 
     * @return The unique identifier of the bot that contains the locale.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code>
     * version.
     * </p>
     * 
     * @return The version of the bot that contains the locale to be updated. The version can only be the
     *         <code>DRAFT</code> version.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale to update. The string must match one of the supported locales. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html">https://docs.aws.amazon
     * .com/lex/latest/dg/supported-locales.html</a>.
     * </p>
     * 
     * @return The identifier of the language and locale to update. The string must match one of the supported locales.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html">https
     *         ://docs.aws.amazon.com/lex/latest/dg/supported-locales.html</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The new description of the locale.
     * </p>
     * 
     * @return The new description of the locale.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
     * <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
     * </p>
     * 
     * @return The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
     *         <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
     */
    public final Double nluIntentConfidenceThreshold() {
        return nluIntentConfidenceThreshold;
    }

    /**
     * <p>
     * The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.
     * </p>
     * 
     * @return The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.
     */
    public final VoiceSettings voiceSettings() {
        return voiceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(voiceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotLocaleRequest)) {
            return false;
        }
        UpdateBotLocaleRequest other = (UpdateBotLocaleRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(description(), other.description())
                && Objects.equals(nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold())
                && Objects.equals(voiceSettings(), other.voiceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBotLocaleRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("Description", description())
                .add("NluIntentConfidenceThreshold", nluIntentConfidenceThreshold()).add("VoiceSettings", voiceSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nluIntentConfidenceThreshold":
            return Optional.ofNullable(clazz.cast(nluIntentConfidenceThreshold()));
        case "voiceSettings":
            return Optional.ofNullable(clazz.cast(voiceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotLocaleRequest, T> g) {
        return obj -> g.apply((UpdateBotLocaleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBotLocaleRequest> {
        /**
         * <p>
         * The unique identifier of the bot that contains the locale.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that contains the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code>
         * version.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the locale to be updated. The version can only be the
         *        <code>DRAFT</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale to update. The string must match one of the supported locales. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html">https://docs.
         * aws.amazon.com/lex/latest/dg/supported-locales.html</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale to update. The string must match one of the supported
         *        locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html"
         *        >https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The new description of the locale.
         * </p>
         * 
         * @param description
         *        The new description of the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
         * <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
         * </p>
         * 
         * @param nluIntentConfidenceThreshold
         *        The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and
         *        <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold);

        /**
         * <p>
         * The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.
         * </p>
         * 
         * @param voiceSettings
         *        The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceSettings(VoiceSettings voiceSettings);

        /**
         * <p>
         * The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.
         * </p>
         * This is a convenience that creates an instance of the {@link VoiceSettings.Builder} avoiding the need to
         * create one manually via {@link VoiceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VoiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceSettings(VoiceSettings)}.
         * 
         * @param voiceSettings
         *        a consumer that will call methods on {@link VoiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceSettings(VoiceSettings)
         */
        default Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return voiceSettings(VoiceSettings.builder().applyMutation(voiceSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String description;

        private Double nluIntentConfidenceThreshold;

        private VoiceSettings voiceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotLocaleRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            description(model.description);
            nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            voiceSettings(model.voiceSettings);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return voiceSettings != null ? voiceSettings.toBuilder() : null;
        }

        @Override
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBotLocaleRequest build() {
            return new UpdateBotLocaleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
