/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a list of values that Amazon Lex should use as the default value for a slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotDefaultValueSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotDefaultValueSpecification.Builder, SlotDefaultValueSpecification> {
    private static final SdkField<List<SlotDefaultValue>> DEFAULT_VALUE_LIST_FIELD = SdkField
            .<List<SlotDefaultValue>> builder(MarshallingType.LIST)
            .memberName("defaultValueList")
            .getter(getter(SlotDefaultValueSpecification::defaultValueList))
            .setter(setter(Builder::defaultValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotDefaultValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotDefaultValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SlotDefaultValue> defaultValueList;

    private SlotDefaultValueSpecification(BuilderImpl builder) {
        this.defaultValueList = builder.defaultValueList;
    }

    /**
     * Returns true if the DefaultValueList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDefaultValueList() {
        return defaultValueList != null && !(defaultValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of default values. Amazon Lex chooses the default value to use in the order that they are presented in the
     * list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefaultValueList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of default values. Amazon Lex chooses the default value to use in the order that they are
     *         presented in the list.
     */
    public final List<SlotDefaultValue> defaultValueList() {
        return defaultValueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultValueList() ? defaultValueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotDefaultValueSpecification)) {
            return false;
        }
        SlotDefaultValueSpecification other = (SlotDefaultValueSpecification) obj;
        return hasDefaultValueList() == other.hasDefaultValueList()
                && Objects.equals(defaultValueList(), other.defaultValueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotDefaultValueSpecification")
                .add("DefaultValueList", hasDefaultValueList() ? defaultValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultValueList":
            return Optional.ofNullable(clazz.cast(defaultValueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotDefaultValueSpecification, T> g) {
        return obj -> g.apply((SlotDefaultValueSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotDefaultValueSpecification> {
        /**
         * <p>
         * A list of default values. Amazon Lex chooses the default value to use in the order that they are presented in
         * the list.
         * </p>
         * 
         * @param defaultValueList
         *        A list of default values. Amazon Lex chooses the default value to use in the order that they are
         *        presented in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValueList(Collection<SlotDefaultValue> defaultValueList);

        /**
         * <p>
         * A list of default values. Amazon Lex chooses the default value to use in the order that they are presented in
         * the list.
         * </p>
         * 
         * @param defaultValueList
         *        A list of default values. Amazon Lex chooses the default value to use in the order that they are
         *        presented in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValueList(SlotDefaultValue... defaultValueList);

        /**
         * <p>
         * A list of default values. Amazon Lex chooses the default value to use in the order that they are presented in
         * the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotDefaultValue>.Builder} avoiding the
         * need to create one manually via {@link List<SlotDefaultValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotDefaultValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultValueList(List<SlotDefaultValue>)}.
         * 
         * @param defaultValueList
         *        a consumer that will call methods on {@link List<SlotDefaultValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValueList(List<SlotDefaultValue>)
         */
        Builder defaultValueList(Consumer<SlotDefaultValue.Builder>... defaultValueList);
    }

    static final class BuilderImpl implements Builder {
        private List<SlotDefaultValue> defaultValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotDefaultValueSpecification model) {
            defaultValueList(model.defaultValueList);
        }

        public final Collection<SlotDefaultValue.Builder> getDefaultValueList() {
            if (defaultValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultValueList != null ? defaultValueList.stream().map(SlotDefaultValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder defaultValueList(Collection<SlotDefaultValue> defaultValueList) {
            this.defaultValueList = SlotDefaultValueListCopier.copy(defaultValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValueList(SlotDefaultValue... defaultValueList) {
            defaultValueList(Arrays.asList(defaultValueList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValueList(Consumer<SlotDefaultValue.Builder>... defaultValueList) {
            defaultValueList(Stream.of(defaultValueList).map(c -> SlotDefaultValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultValueList(Collection<SlotDefaultValue.BuilderImpl> defaultValueList) {
            this.defaultValueList = SlotDefaultValueListCopier.copyFromBuilder(defaultValueList);
        }

        @Override
        public SlotDefaultValueSpecification build() {
            return new SlotDefaultValueSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
