/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MessageVariationsListCopier {
    static List<Message> copy(Collection<Message> messageVariationsListParam) {
        if (messageVariationsListParam == null || messageVariationsListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<Message> messageVariationsListParamCopy = new ArrayList<>(messageVariationsListParam);
        return Collections.unmodifiableList(messageVariationsListParamCopy);
    }

    static List<Message> copyFromBuilder(Collection<? extends Message.Builder> messageVariationsListParam) {
        if (messageVariationsListParam == null || messageVariationsListParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(messageVariationsListParam.stream().map(Message.Builder::build).collect(toList()));
    }
}
