/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * By default, data stored by Amazon Lex is encrypted. The <code>DataPrivacy</code> structure provides settings that
 * determine how Amazon Lex handles special cases of securing the data for your bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPrivacy implements SdkPojo, Serializable, ToCopyableBuilder<DataPrivacy.Builder, DataPrivacy> {
    private static final SdkField<Boolean> CHILD_DIRECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("childDirected").getter(getter(DataPrivacy::childDirected)).setter(setter(Builder::childDirected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childDirected").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHILD_DIRECTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean childDirected;

    private DataPrivacy(BuilderImpl builder) {
        this.childDirected = builder.childDirected;
    }

    /**
     * <p>
     * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of
     * Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in
     * part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying
     * <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code>
     * in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website,
     * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
     * subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
     * use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted,
     * in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the
     * <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a
     * website, program, or other application that is directed or targeted, in whole or in part, to children under age
     * 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is
     * directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent
     * under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other
     * applications that are directed or targeted, in whole or in part, to children under age 13, see the <a
     * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a>.
     * </p>
     * 
     * @return For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your
     *         use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in
     *         whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act
     *         (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By
     *         specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon
     *         Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole
     *         or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the
     *         <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a
     *         website, program, or other application that is directed or targeted, in whole or in part, to children
     *         under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code>
     *         field that does not accurately reflect whether your use of Amazon Lex is related to a website, program,
     *         or other application that is directed or targeted, in whole or in part, to children under age 13 and
     *         subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is
     *         directed in whole or in part, to children under age 13, you must obtain any required verifiable parental
     *         consent under COPPA. For information regarding the use of Amazon Lex in connection with websites,
     *         programs, or other applications that are directed or targeted, in whole or in part, to children under age
     *         13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a>.
     */
    public final Boolean childDirected() {
        return childDirected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(childDirected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPrivacy)) {
            return false;
        }
        DataPrivacy other = (DataPrivacy) obj;
        return Objects.equals(childDirected(), other.childDirected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPrivacy").add("ChildDirected", childDirected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "childDirected":
            return Optional.ofNullable(clazz.cast(childDirected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataPrivacy, T> g) {
        return obj -> g.apply((DataPrivacy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPrivacy> {
        /**
         * <p>
         * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use
         * of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole
         * or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by
         * specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying
         * <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b>
         * related to a website, program, or other application that is directed or targeted, in whole or in part, to
         * children under age 13 and subject to COPPA. By specifying <code>false</code> in the
         * <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website,
         * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
         * subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not
         * accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that
         * is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of
         * Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to
         * children under age 13, you must obtain any required verifiable parental consent under COPPA. For information
         * regarding the use of Amazon Lex in connection with websites, programs, or other applications that are
         * directed or targeted, in whole or in part, to children under age 13, see the <a
         * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a>.
         * </p>
         * 
         * @param childDirected
         *        For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether
         *        your use of Amazon Lex is related to a website, program, or other application that is directed or
         *        targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy
         *        Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the
         *        <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code>
         *        field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other
         *        application that is directed or targeted, in whole or in part, to children under age 13 and subject to
         *        COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
         *        use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed
         *        or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a
         *        default value for the <code>childDirected</code> field that does not accurately reflect whether your
         *        use of Amazon Lex is related to a website, program, or other application that is directed or targeted,
         *        in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates
         *        to a website, program, or other application that is directed in whole or in part, to children under
         *        age 13, you must obtain any required verifiable parental consent under COPPA. For information
         *        regarding the use of Amazon Lex in connection with websites, programs, or other applications that are
         *        directed or targeted, in whole or in part, to children under age 13, see the <a
         *        href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childDirected(Boolean childDirected);
    }

    static final class BuilderImpl implements Builder {
        private Boolean childDirected;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPrivacy model) {
            childDirected(model.childDirected);
        }

        public final Boolean getChildDirected() {
            return childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        @Override
        public DataPrivacy build() {
            return new DataPrivacy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
