/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateBotResponse.Builder, CreateBotResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(CreateBotResponse::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateBotResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.<DataPrivacy> builder(MarshallingType.SDK_POJO)
            .memberName("dataPrivacy").getter(getter(CreateBotResponse::dataPrivacy)).setter(setter(Builder::dataPrivacy))
            .constructor(DataPrivacy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(CreateBotResponse::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botStatus").getter(getter(CreateBotResponse::botStatusAsString)).setter(setter(Builder::botStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateBotResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Map<String, String>> BOT_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("botTags")
            .getter(getter(CreateBotResponse::botTags))
            .setter(setter(Builder::botTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TEST_BOT_ALIAS_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("testBotAliasTags")
            .getter(getter(CreateBotResponse::testBotAliasTags))
            .setter(setter(Builder::testBotAliasTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testBotAliasTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD,
            DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_STATUS_FIELD,
            CREATION_DATE_TIME_FIELD, BOT_TAGS_FIELD, TEST_BOT_ALIAS_TAGS_FIELD));

    private final String botId;

    private final String botName;

    private final String description;

    private final String roleArn;

    private final DataPrivacy dataPrivacy;

    private final Integer idleSessionTTLInSeconds;

    private final String botStatus;

    private final Instant creationDateTime;

    private final Map<String, String> botTags;

    private final Map<String, String> testBotAliasTags;

    private CreateBotResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botStatus = builder.botStatus;
        this.creationDateTime = builder.creationDateTime;
        this.botTags = builder.botTags;
        this.testBotAliasTags = builder.testBotAliasTags;
    }

    /**
     * <p>
     * A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API
     * operations.
     * </p>
     * 
     * @return A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex
     *         API operations.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The name specified for the bot.
     * </p>
     * 
     * @return The name specified for the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The description specified for the bot.
     * </p>
     * 
     * @return The description specified for the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IAM role specified for the bot.
     * </p>
     * 
     * @return The IAM role specified for the bot.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The data privacy settings specified for the bot.
     * </p>
     * 
     * @return The data privacy settings specified for the bot.
     */
    public final DataPrivacy dataPrivacy() {
        return dataPrivacy;
    }

    /**
     * <p>
     * The session idle time specified for the bot.
     * </p>
     * 
     * @return The session idle time specified for the bot.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read
     * for use, it changes to the <code>Available</code> status. After the bot is created, you can use the
     * <code>Draft</code> version of the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot
     *         is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use
     *         the <code>Draft</code> version of the bot.
     * @see BotStatus
     */
    public final BotStatus botStatus() {
        return BotStatus.fromValue(botStatus);
    }

    /**
     * <p>
     * Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read
     * for use, it changes to the <code>Available</code> status. After the bot is created, you can use the
     * <code>Draft</code> version of the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot
     *         is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use
     *         the <code>Draft</code> version of the bot.
     * @see BotStatus
     */
    public final String botStatusAsString() {
        return botStatus;
    }

    /**
     * <p>
     * A timestamp indicating the date and time that the bot was created.
     * </p>
     * 
     * @return A timestamp indicating the date and time that the bot was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * Returns true if the BotTags property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBotTags() {
        return botTags != null && !(botTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags associated with the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBotTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags associated with the bot.
     */
    public final Map<String, String> botTags() {
        return botTags;
    }

    /**
     * Returns true if the TestBotAliasTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTestBotAliasTags() {
        return testBotAliasTags != null && !(testBotAliasTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags associated with the test alias for the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTestBotAliasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags associated with the test alias for the bot.
     */
    public final Map<String, String> testBotAliasTags() {
        return testBotAliasTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotTags() ? botTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTestBotAliasTags() ? testBotAliasTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotResponse)) {
            return false;
        }
        CreateBotResponse other = (CreateBotResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botName(), other.botName())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPrivacy(), other.dataPrivacy())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(botStatusAsString(), other.botStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime()) && hasBotTags() == other.hasBotTags()
                && Objects.equals(botTags(), other.botTags()) && hasTestBotAliasTags() == other.hasTestBotAliasTags()
                && Objects.equals(testBotAliasTags(), other.testBotAliasTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBotResponse").add("BotId", botId()).add("BotName", botName())
                .add("Description", description()).add("RoleArn", roleArn()).add("DataPrivacy", dataPrivacy())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds()).add("BotStatus", botStatusAsString())
                .add("CreationDateTime", creationDateTime()).add("BotTags", hasBotTags() ? botTags() : null)
                .add("TestBotAliasTags", hasTestBotAliasTags() ? testBotAliasTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataPrivacy":
            return Optional.ofNullable(clazz.cast(dataPrivacy()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "botStatus":
            return Optional.ofNullable(clazz.cast(botStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "botTags":
            return Optional.ofNullable(clazz.cast(botTags()));
        case "testBotAliasTags":
            return Optional.ofNullable(clazz.cast(testBotAliasTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBotResponse, T> g) {
        return obj -> g.apply((CreateBotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotResponse> {
        /**
         * <p>
         * A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API
         * operations.
         * </p>
         * 
         * @param botId
         *        A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon
         *        Lex API operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The name specified for the bot.
         * </p>
         * 
         * @param botName
         *        The name specified for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The description specified for the bot.
         * </p>
         * 
         * @param description
         *        The description specified for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IAM role specified for the bot.
         * </p>
         * 
         * @param roleArn
         *        The IAM role specified for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The data privacy settings specified for the bot.
         * </p>
         * 
         * @param dataPrivacy
         *        The data privacy settings specified for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacy(DataPrivacy dataPrivacy);

        /**
         * <p>
         * The data privacy settings specified for the bot.
         * </p>
         * This is a convenience that creates an instance of the {@link DataPrivacy.Builder} avoiding the need to create
         * one manually via {@link DataPrivacy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataPrivacy.Builder#build()} is called immediately and its result
         * is passed to {@link #dataPrivacy(DataPrivacy)}.
         * 
         * @param dataPrivacy
         *        a consumer that will call methods on {@link DataPrivacy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacy(DataPrivacy)
         */
        default Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return dataPrivacy(DataPrivacy.builder().applyMutation(dataPrivacy).build());
        }

        /**
         * <p>
         * The session idle time specified for the bot.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The session idle time specified for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is
         * read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the
         * <code>Draft</code> version of the bot.
         * </p>
         * 
         * @param botStatus
         *        Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the
         *        bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you
         *        can use the <code>Draft</code> version of the bot.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(String botStatus);

        /**
         * <p>
         * Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is
         * read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the
         * <code>Draft</code> version of the bot.
         * </p>
         * 
         * @param botStatus
         *        Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the
         *        bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you
         *        can use the <code>Draft</code> version of the bot.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(BotStatus botStatus);

        /**
         * <p>
         * A timestamp indicating the date and time that the bot was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp indicating the date and time that the bot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A list of tags associated with the bot.
         * </p>
         * 
         * @param botTags
         *        A list of tags associated with the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botTags(Map<String, String> botTags);

        /**
         * <p>
         * A list of tags associated with the test alias for the bot.
         * </p>
         * 
         * @param testBotAliasTags
         *        A list of tags associated with the test alias for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testBotAliasTags(Map<String, String> testBotAliasTags);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botName;

        private String description;

        private String roleArn;

        private DataPrivacy dataPrivacy;

        private Integer idleSessionTTLInSeconds;

        private String botStatus;

        private Instant creationDateTime;

        private Map<String, String> botTags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> testBotAliasTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotResponse model) {
            super(model);
            botId(model.botId);
            botName(model.botName);
            description(model.description);
            roleArn(model.roleArn);
            dataPrivacy(model.dataPrivacy);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            botStatus(model.botStatus);
            creationDateTime(model.creationDateTime);
            botTags(model.botTags);
            testBotAliasTags(model.testBotAliasTags);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return dataPrivacy != null ? dataPrivacy.toBuilder() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final String getBotStatus() {
            return botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Map<String, String> getBotTags() {
            if (botTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return botTags;
        }

        @Override
        public final Builder botTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
            return this;
        }

        public final void setBotTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
        }

        public final Map<String, String> getTestBotAliasTags() {
            if (testBotAliasTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return testBotAliasTags;
        }

        @Override
        public final Builder testBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
            return this;
        }

        public final void setTestBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
        }

        @Override
        public CreateBotResponse build() {
            return new CreateBotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
