/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuildBotLocaleResponse extends LexModelsV2Response implements
        ToCopyableBuilder<BuildBotLocaleResponse.Builder, BuildBotLocaleResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(BuildBotLocaleResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BuildBotLocaleResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(BuildBotLocaleResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleStatus").getter(getter(BuildBotLocaleResponse::botLocaleStatusAsString))
            .setter(setter(Builder::botLocaleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()).build();

    private static final SdkField<Instant> LAST_BUILD_SUBMITTED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastBuildSubmittedDateTime")
            .getter(getter(BuildBotLocaleResponse::lastBuildSubmittedDateTime))
            .setter(setter(Builder::lastBuildSubmittedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastBuildSubmittedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_LOCALE_STATUS_FIELD, LAST_BUILD_SUBMITTED_DATE_TIME_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String botLocaleStatus;

    private final Instant lastBuildSubmittedDateTime;

    private BuildBotLocaleResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.lastBuildSubmittedDateTime = builder.lastBuildSubmittedDateTime;
    }

    /**
     * <p>
     * The identifier of the specified bot.
     * </p>
     * 
     * @return The identifier of the specified bot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that was built. This is only the draft version of the bot.
     * </p>
     * 
     * @return The version of the bot that was built. This is only the draft version of the bot.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The language and locale specified of where the bot can be used.
     * </p>
     * 
     * @return The language and locale specified of where the bot can be used.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the
     * utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for
     * use and can be tested using any utterance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using
     *         the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is
     *         ready for use and can be tested using any utterance.
     * @see BotLocaleStatus
     */
    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(botLocaleStatus);
    }

    /**
     * <p>
     * The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the
     * utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for
     * use and can be tested using any utterance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using
     *         the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is
     *         ready for use and can be tested using any utterance.
     * @see BotLocaleStatus
     */
    public final String botLocaleStatusAsString() {
        return botLocaleStatus;
    }

    /**
     * <p>
     * A timestamp indicating the date and time that the bot was last built for this locale.
     * </p>
     * 
     * @return A timestamp indicating the date and time that the bot was last built for this locale.
     */
    public final Instant lastBuildSubmittedDateTime() {
        return lastBuildSubmittedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastBuildSubmittedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildBotLocaleResponse)) {
            return false;
        }
        BuildBotLocaleResponse other = (BuildBotLocaleResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(botLocaleStatusAsString(), other.botLocaleStatusAsString())
                && Objects.equals(lastBuildSubmittedDateTime(), other.lastBuildSubmittedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuildBotLocaleResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("BotLocaleStatus", botLocaleStatusAsString())
                .add("LastBuildSubmittedDateTime", lastBuildSubmittedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "botLocaleStatus":
            return Optional.ofNullable(clazz.cast(botLocaleStatusAsString()));
        case "lastBuildSubmittedDateTime":
            return Optional.ofNullable(clazz.cast(lastBuildSubmittedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildBotLocaleResponse, T> g) {
        return obj -> g.apply((BuildBotLocaleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, BuildBotLocaleResponse> {
        /**
         * <p>
         * The identifier of the specified bot.
         * </p>
         * 
         * @param botId
         *        The identifier of the specified bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that was built. This is only the draft version of the bot.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that was built. This is only the draft version of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The language and locale specified of where the bot can be used.
         * </p>
         * 
         * @param localeId
         *        The language and locale specified of where the bot can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the
         * utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready
         * for use and can be tested using any utterance.
         * </p>
         * 
         * @param botLocaleStatus
         *        The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using
         *        the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot
         *        is ready for use and can be tested using any utterance.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(String botLocaleStatus);

        /**
         * <p>
         * The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the
         * utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready
         * for use and can be tested using any utterance.
         * </p>
         * 
         * @param botLocaleStatus
         *        The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using
         *        the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot
         *        is ready for use and can be tested using any utterance.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(BotLocaleStatus botLocaleStatus);

        /**
         * <p>
         * A timestamp indicating the date and time that the bot was last built for this locale.
         * </p>
         * 
         * @param lastBuildSubmittedDateTime
         *        A timestamp indicating the date and time that the bot was last built for this locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String botLocaleStatus;

        private Instant lastBuildSubmittedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildBotLocaleResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            botLocaleStatus(model.botLocaleStatus);
            lastBuildSubmittedDateTime(model.lastBuildSubmittedDateTime);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final String getBotLocaleStatus() {
            return botLocaleStatus;
        }

        @Override
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        public final Instant getLastBuildSubmittedDateTime() {
            return lastBuildSubmittedDateTime;
        }

        @Override
        public final Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
            return this;
        }

        public final void setLastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
        }

        @Override
        public BuildBotLocaleResponse build() {
            return new BuildBotLocaleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
