/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkloadStatus {
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    DISABLED("DISABLED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkloadStatus> VALUE_MAP;
    private final String value;

    private WorkloadStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkloadStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkloadStatus> knownValues() {
        EnumSet<WorkloadStatus> knownValues = EnumSet.allOf(WorkloadStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkloadStatus.class, WorkloadStatus::toString);
    }
}

