/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.launchwizard.model.WorkloadStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadData> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkloadData.getter(WorkloadData::description)).setter(WorkloadData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(WorkloadData.getter(WorkloadData::displayName)).setter(WorkloadData.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DOCUMENTATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentationUrl").getter(WorkloadData.getter(WorkloadData::documentationUrl)).setter(WorkloadData.setter(Builder::documentationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentationUrl").build()}).build();
    private static final SdkField<String> ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iconUrl").getter(WorkloadData.getter(WorkloadData::iconUrl)).setter(WorkloadData.setter(Builder::iconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iconUrl").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkloadData.getter(WorkloadData::statusAsString)).setter(WorkloadData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(WorkloadData.getter(WorkloadData::statusMessage)).setter(WorkloadData.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadName").getter(WorkloadData.getter(WorkloadData::workloadName)).setter(WorkloadData.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, DOCUMENTATION_URL_FIELD, ICON_URL_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, WORKLOAD_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String displayName;
    private final String documentationUrl;
    private final String iconUrl;
    private final String status;
    private final String statusMessage;
    private final String workloadName;

    private WorkloadData(BuilderImpl builder) {
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.documentationUrl = builder.documentationUrl;
        this.iconUrl = builder.iconUrl;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.workloadName = builder.workloadName;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String documentationUrl() {
        return this.documentationUrl;
    }

    public final String iconUrl() {
        return this.iconUrl;
    }

    public final WorkloadStatus status() {
        return WorkloadStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadData)) {
            return false;
        }
        WorkloadData other = (WorkloadData)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.documentationUrl(), other.documentationUrl()) && Objects.equals(this.iconUrl(), other.iconUrl()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.workloadName(), other.workloadName());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadData").add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("DocumentationUrl", (Object)this.documentationUrl()).add("IconUrl", (Object)this.iconUrl()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("WorkloadName", (Object)this.workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "documentationUrl": {
                return Optional.ofNullable(clazz.cast(this.documentationUrl()));
            }
            case "iconUrl": {
                return Optional.ofNullable(clazz.cast(this.iconUrl()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "workloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadData, T> g) {
        return obj -> g.apply((WorkloadData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String displayName;
        private String documentationUrl;
        private String iconUrl;
        private String status;
        private String statusMessage;
        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadData model) {
            this.description(model.description);
            this.displayName(model.displayName);
            this.documentationUrl(model.documentationUrl);
            this.iconUrl(model.iconUrl);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.workloadName(model.workloadName);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDocumentationUrl() {
            return this.documentationUrl;
        }

        public final void setDocumentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        @Override
        public final Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final String getIconUrl() {
            return this.iconUrl;
        }

        public final void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        @Override
        public final Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public WorkloadData build() {
            return new WorkloadData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadData> {
        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder documentationUrl(String var1);

        public Builder iconUrl(String var1);

        public Builder status(String var1);

        public Builder status(WorkloadStatus var1);

        public Builder statusMessage(String var1);

        public Builder workloadName(String var1);
    }
}

