/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.launchwizard.DefaultLaunchWizardAsyncClientBuilder;
import software.amazon.awssdk.services.launchwizard.LaunchWizardAsyncClientBuilder;
import software.amazon.awssdk.services.launchwizard.LaunchWizardServiceClientConfiguration;
import software.amazon.awssdk.services.launchwizard.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.launchwizard.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.launchwizard.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.launchwizard.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.launchwizard.model.GetDeploymentRequest;
import software.amazon.awssdk.services.launchwizard.model.GetDeploymentResponse;
import software.amazon.awssdk.services.launchwizard.model.GetWorkloadRequest;
import software.amazon.awssdk.services.launchwizard.model.GetWorkloadResponse;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsResponse;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsResponse;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsPublisher;
import software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsPublisher;
import software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsPublisher;
import software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsPublisher;

@SdkPublicApi
@ThreadSafe
public interface LaunchWizardAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "launchwizard";
    public static final String SERVICE_METADATA_ID = "launchwizard";

    default public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateDeploymentResponse> createDeployment(Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest) {
        return this.createDeployment((CreateDeploymentRequest)((Object)((CreateDeploymentRequest.Builder)CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest)).build()));
    }

    default public CompletableFuture<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteDeploymentResponse> deleteDeployment(Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest) {
        return this.deleteDeployment((DeleteDeploymentRequest)((Object)((DeleteDeploymentRequest.Builder)DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest)).build()));
    }

    default public CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return this.getDeployment((GetDeploymentRequest)((Object)((GetDeploymentRequest.Builder)GetDeploymentRequest.builder().applyMutation(getDeploymentRequest)).build()));
    }

    default public CompletableFuture<GetWorkloadResponse> getWorkload(GetWorkloadRequest getWorkloadRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetWorkloadResponse> getWorkload(Consumer<GetWorkloadRequest.Builder> getWorkloadRequest) {
        return this.getWorkload((GetWorkloadRequest)((Object)((GetWorkloadRequest.Builder)GetWorkloadRequest.builder().applyMutation(getWorkloadRequest)).build()));
    }

    default public CompletableFuture<ListDeploymentEventsResponse> listDeploymentEvents(ListDeploymentEventsRequest listDeploymentEventsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListDeploymentEventsResponse> listDeploymentEvents(Consumer<ListDeploymentEventsRequest.Builder> listDeploymentEventsRequest) {
        return this.listDeploymentEvents((ListDeploymentEventsRequest)((Object)((ListDeploymentEventsRequest.Builder)ListDeploymentEventsRequest.builder().applyMutation(listDeploymentEventsRequest)).build()));
    }

    default public ListDeploymentEventsPublisher listDeploymentEventsPaginator(ListDeploymentEventsRequest listDeploymentEventsRequest) {
        return new ListDeploymentEventsPublisher(this, listDeploymentEventsRequest);
    }

    default public ListDeploymentEventsPublisher listDeploymentEventsPaginator(Consumer<ListDeploymentEventsRequest.Builder> listDeploymentEventsRequest) {
        return this.listDeploymentEventsPaginator((ListDeploymentEventsRequest)((Object)((ListDeploymentEventsRequest.Builder)ListDeploymentEventsRequest.builder().applyMutation(listDeploymentEventsRequest)).build()));
    }

    default public CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListDeploymentsResponse> listDeployments(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return this.listDeployments((ListDeploymentsRequest)((Object)((ListDeploymentsRequest.Builder)ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest)).build()));
    }

    default public ListDeploymentsPublisher listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest) {
        return new ListDeploymentsPublisher(this, listDeploymentsRequest);
    }

    default public ListDeploymentsPublisher listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return this.listDeploymentsPaginator((ListDeploymentsRequest)((Object)((ListDeploymentsRequest.Builder)ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest)).build()));
    }

    default public CompletableFuture<ListWorkloadDeploymentPatternsResponse> listWorkloadDeploymentPatterns(ListWorkloadDeploymentPatternsRequest listWorkloadDeploymentPatternsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListWorkloadDeploymentPatternsResponse> listWorkloadDeploymentPatterns(Consumer<ListWorkloadDeploymentPatternsRequest.Builder> listWorkloadDeploymentPatternsRequest) {
        return this.listWorkloadDeploymentPatterns((ListWorkloadDeploymentPatternsRequest)((Object)((ListWorkloadDeploymentPatternsRequest.Builder)ListWorkloadDeploymentPatternsRequest.builder().applyMutation(listWorkloadDeploymentPatternsRequest)).build()));
    }

    default public ListWorkloadDeploymentPatternsPublisher listWorkloadDeploymentPatternsPaginator(ListWorkloadDeploymentPatternsRequest listWorkloadDeploymentPatternsRequest) {
        return new ListWorkloadDeploymentPatternsPublisher(this, listWorkloadDeploymentPatternsRequest);
    }

    default public ListWorkloadDeploymentPatternsPublisher listWorkloadDeploymentPatternsPaginator(Consumer<ListWorkloadDeploymentPatternsRequest.Builder> listWorkloadDeploymentPatternsRequest) {
        return this.listWorkloadDeploymentPatternsPaginator((ListWorkloadDeploymentPatternsRequest)((Object)((ListWorkloadDeploymentPatternsRequest.Builder)ListWorkloadDeploymentPatternsRequest.builder().applyMutation(listWorkloadDeploymentPatternsRequest)).build()));
    }

    default public CompletableFuture<ListWorkloadsResponse> listWorkloads(ListWorkloadsRequest listWorkloadsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListWorkloadsResponse> listWorkloads(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest) {
        return this.listWorkloads((ListWorkloadsRequest)((Object)((ListWorkloadsRequest.Builder)ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest)).build()));
    }

    default public ListWorkloadsPublisher listWorkloadsPaginator(ListWorkloadsRequest listWorkloadsRequest) {
        return new ListWorkloadsPublisher(this, listWorkloadsRequest);
    }

    default public ListWorkloadsPublisher listWorkloadsPaginator(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest) {
        return this.listWorkloadsPaginator((ListWorkloadsRequest)((Object)((ListWorkloadsRequest.Builder)ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest)).build()));
    }

    default public LaunchWizardServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static LaunchWizardAsyncClient create() {
        return (LaunchWizardAsyncClient)LaunchWizardAsyncClient.builder().build();
    }

    public static LaunchWizardAsyncClientBuilder builder() {
        return new DefaultLaunchWizardAsyncClientBuilder();
    }
}

