/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.launchwizard.DefaultLaunchWizardBaseClientBuilder;
import software.amazon.awssdk.services.launchwizard.DefaultLaunchWizardClient;
import software.amazon.awssdk.services.launchwizard.LaunchWizardClient;
import software.amazon.awssdk.services.launchwizard.LaunchWizardClientBuilder;
import software.amazon.awssdk.services.launchwizard.LaunchWizardServiceClientConfiguration;
import software.amazon.awssdk.services.launchwizard.endpoints.LaunchWizardEndpointProvider;

@SdkInternalApi
final class DefaultLaunchWizardClientBuilder
extends DefaultLaunchWizardBaseClientBuilder<LaunchWizardClientBuilder, LaunchWizardClient>
implements LaunchWizardClientBuilder {
    DefaultLaunchWizardClientBuilder() {
    }

    @Override
    public DefaultLaunchWizardClientBuilder endpointProvider(LaunchWizardEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LaunchWizardClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLaunchWizardClientBuilder.validateClientOptions(clientConfiguration);
        LaunchWizardServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLaunchWizardClient client = new DefaultLaunchWizardClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LaunchWizardServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LaunchWizardServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

