/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.CodeSigningConfig;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse;

public class ListCodeSigningConfigsPublisher
implements SdkPublisher<ListCodeSigningConfigsResponse> {
    private final LambdaAsyncClient client;
    private final ListCodeSigningConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCodeSigningConfigsPublisher(LambdaAsyncClient client, ListCodeSigningConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCodeSigningConfigsPublisher(LambdaAsyncClient client, ListCodeSigningConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCodeSigningConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCodeSigningConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CodeSigningConfig> codeSigningConfigs() {
        Function<ListCodeSigningConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeSigningConfigs() != null) {
                return response.codeSigningConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCodeSigningConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCodeSigningConfigsResponseFetcher
    implements AsyncPageFetcher<ListCodeSigningConfigsResponse> {
        private ListCodeSigningConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeSigningConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListCodeSigningConfigsResponse> nextPage(ListCodeSigningConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListCodeSigningConfigsPublisher.this.client.listCodeSigningConfigs(ListCodeSigningConfigsPublisher.this.firstRequest);
            }
            return ListCodeSigningConfigsPublisher.this.client.listCodeSigningConfigs((ListCodeSigningConfigsRequest)((Object)ListCodeSigningConfigsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

