/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDurableExecutionRequest extends LambdaRequest implements
        ToCopyableBuilder<StopDurableExecutionRequest.Builder, StopDurableExecutionRequest> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionArn").getter(getter(StopDurableExecutionRequest::durableExecutionArn))
            .setter(setter(Builder::durableExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DurableExecutionArn").build()).build();

    private static final SdkField<ErrorObject> ERROR_FIELD = SdkField
            .<ErrorObject> builder(MarshallingType.SDK_POJO)
            .memberName("Error")
            .getter(getter(StopDurableExecutionRequest::error))
            .setter(setter(Builder::error))
            .constructor(ErrorObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD,
            ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String durableExecutionArn;

    private final ErrorObject error;

    private StopDurableExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.error = builder.error;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the durable execution.
     */
    public final String durableExecutionArn() {
        return durableExecutionArn;
    }

    /**
     * <p>
     * Optional error details explaining why the execution is being stopped.
     * </p>
     * 
     * @return Optional error details explaining why the execution is being stopped.
     */
    public final ErrorObject error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDurableExecutionRequest)) {
            return false;
        }
        StopDurableExecutionRequest other = (StopDurableExecutionRequest) obj;
        return Objects.equals(durableExecutionArn(), other.durableExecutionArn()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDurableExecutionRequest").add("DurableExecutionArn", durableExecutionArn())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurableExecutionArn":
            return Optional.ofNullable(clazz.cast(durableExecutionArn()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopDurableExecutionRequest, T> g) {
        return obj -> g.apply((StopDurableExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopDurableExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the durable execution.
         * </p>
         * 
         * @param durableExecutionArn
         *        The Amazon Resource Name (ARN) of the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionArn(String durableExecutionArn);

        /**
         * <p>
         * Optional error details explaining why the execution is being stopped.
         * </p>
         * 
         * @param error
         *        Optional error details explaining why the execution is being stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorObject error);

        /**
         * <p>
         * Optional error details explaining why the execution is being stopped.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorObject.Builder} avoiding the need to
         * create one manually via {@link ErrorObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorObject.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorObject)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorObject)
         */
        default Builder error(Consumer<ErrorObject.Builder> error) {
            return error(ErrorObject.builder().applyMutation(error).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String durableExecutionArn;

        private ErrorObject error;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDurableExecutionRequest model) {
            super(model);
            durableExecutionArn(model.durableExecutionArn);
            error(model.error);
        }

        public final String getDurableExecutionArn() {
            return durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final ErrorObject.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorObject.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorObject error) {
            this.error = error;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopDurableExecutionRequest build() {
            return new StopDurableExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
