/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the ListDurableExecutionsByFunction operation, containing a list of durable executions and
 * pagination information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDurableExecutionsByFunctionResponse extends LambdaResponse implements
        ToCopyableBuilder<ListDurableExecutionsByFunctionResponse.Builder, ListDurableExecutionsByFunctionResponse> {
    private static final SdkField<List<Execution>> DURABLE_EXECUTIONS_FIELD = SdkField
            .<List<Execution>> builder(MarshallingType.LIST)
            .memberName("DurableExecutions")
            .getter(getter(ListDurableExecutionsByFunctionResponse::durableExecutions))
            .setter(setter(Builder::durableExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Execution> builder(MarshallingType.SDK_POJO)
                                            .constructor(Execution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListDurableExecutionsByFunctionResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTIONS_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Execution> durableExecutions;

    private final String nextMarker;

    private ListDurableExecutionsByFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.durableExecutions = builder.durableExecutions;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DurableExecutions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDurableExecutions() {
        return durableExecutions != null && !(durableExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of durable execution summaries matching the filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDurableExecutions} method.
     * </p>
     * 
     * @return List of durable execution summaries matching the filter criteria.
     */
    public final List<Execution> durableExecutions() {
        return durableExecutions;
    }

    /**
     * <p>
     * Pagination token for retrieving additional results. Present only if there are more results available.
     * </p>
     * 
     * @return Pagination token for retrieving additional results. Present only if there are more results available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDurableExecutions() ? durableExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDurableExecutionsByFunctionResponse)) {
            return false;
        }
        ListDurableExecutionsByFunctionResponse other = (ListDurableExecutionsByFunctionResponse) obj;
        return hasDurableExecutions() == other.hasDurableExecutions()
                && Objects.equals(durableExecutions(), other.durableExecutions())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDurableExecutionsByFunctionResponse")
                .add("DurableExecutions", hasDurableExecutions() ? durableExecutions() : null).add("NextMarker", nextMarker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurableExecutions":
            return Optional.ofNullable(clazz.cast(durableExecutions()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurableExecutions", DURABLE_EXECUTIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDurableExecutionsByFunctionResponse, T> g) {
        return obj -> g.apply((ListDurableExecutionsByFunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDurableExecutionsByFunctionResponse> {
        /**
         * <p>
         * List of durable execution summaries matching the filter criteria.
         * </p>
         * 
         * @param durableExecutions
         *        List of durable execution summaries matching the filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutions(Collection<Execution> durableExecutions);

        /**
         * <p>
         * List of durable execution summaries matching the filter criteria.
         * </p>
         * 
         * @param durableExecutions
         *        List of durable execution summaries matching the filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutions(Execution... durableExecutions);

        /**
         * <p>
         * List of durable execution summaries matching the filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.Execution.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lambda.model.Execution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.Execution.Builder#build()} is called immediately and its
         * result is passed to {@link #durableExecutions(List<Execution>)}.
         * 
         * @param durableExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.Execution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #durableExecutions(java.util.Collection<Execution>)
         */
        Builder durableExecutions(Consumer<Execution.Builder>... durableExecutions);

        /**
         * <p>
         * Pagination token for retrieving additional results. Present only if there are more results available.
         * </p>
         * 
         * @param nextMarker
         *        Pagination token for retrieving additional results. Present only if there are more results available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private List<Execution> durableExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDurableExecutionsByFunctionResponse model) {
            super(model);
            durableExecutions(model.durableExecutions);
            nextMarker(model.nextMarker);
        }

        public final List<Execution.Builder> getDurableExecutions() {
            List<Execution.Builder> result = DurableExecutionsCopier.copyToBuilder(this.durableExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDurableExecutions(Collection<Execution.BuilderImpl> durableExecutions) {
            this.durableExecutions = DurableExecutionsCopier.copyFromBuilder(durableExecutions);
        }

        @Override
        public final Builder durableExecutions(Collection<Execution> durableExecutions) {
            this.durableExecutions = DurableExecutionsCopier.copy(durableExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durableExecutions(Execution... durableExecutions) {
            durableExecutions(Arrays.asList(durableExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durableExecutions(Consumer<Execution.Builder>... durableExecutions) {
            durableExecutions(Stream.of(durableExecutions).map(c -> Execution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListDurableExecutionsByFunctionResponse build() {
            return new ListDurableExecutionsByFunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
