/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a function invocation that completed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvocationCompletedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InvocationCompletedDetails.Builder, InvocationCompletedDetails> {
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(InvocationCompletedDetails::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(InvocationCompletedDetails::endTimestamp))
            .setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(InvocationCompletedDetails::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<EventError> ERROR_FIELD = SdkField.<EventError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(InvocationCompletedDetails::error)).setter(setter(Builder::error))
            .constructor(EventError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIMESTAMP_FIELD,
            END_TIMESTAMP_FIELD, REQUEST_ID_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private final String requestId;

    private final EventError error;

    private InvocationCompletedDetails(BuilderImpl builder) {
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.requestId = builder.requestId;
        this.error = builder.error;
    }

    /**
     * <p>
     * The date and time when the invocation started, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when the invocation started, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     *         format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The date and time when the invocation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when the invocation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     *         format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * <p>
     * The request ID for the invocation.
     * </p>
     * 
     * @return The request ID for the invocation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * Details about the invocation failure.
     * </p>
     * 
     * @return Details about the invocation failure.
     */
    public final EventError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationCompletedDetails)) {
            return false;
        }
        InvocationCompletedDetails other = (InvocationCompletedDetails) obj;
        return Objects.equals(startTimestamp(), other.startTimestamp()) && Objects.equals(endTimestamp(), other.endTimestamp())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvocationCompletedDetails").add("StartTimestamp", startTimestamp())
                .add("EndTimestamp", endTimestamp()).add("RequestId", requestId()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationCompletedDetails, T> g) {
        return obj -> g.apply((InvocationCompletedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvocationCompletedDetails> {
        /**
         * <p>
         * The date and time when the invocation started, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param startTimestamp
         *        The date and time when the invocation started, in <a
         *        href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The date and time when the invocation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param endTimestamp
         *        The date and time when the invocation ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         *        format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * The request ID for the invocation.
         * </p>
         * 
         * @param requestId
         *        The request ID for the invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * Details about the invocation failure.
         * </p>
         * 
         * @param error
         *        Details about the invocation failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(EventError error);

        /**
         * <p>
         * Details about the invocation failure.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventError.Builder} avoiding the need to
         * create one manually via {@link EventError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(EventError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link EventError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(EventError)
         */
        default Builder error(Consumer<EventError.Builder> error) {
            return error(EventError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant startTimestamp;

        private Instant endTimestamp;

        private String requestId;

        private EventError error;

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationCompletedDetails model) {
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
            requestId(model.requestId);
            error(model.error);
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final EventError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(EventError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(EventError error) {
            this.error = error;
            return this;
        }

        @Override
        public InvocationCompletedDetails build() {
            return new InvocationCompletedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
